/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.search.BulkUpdate;
import io.fluxcapacitor.common.api.search.CreateAuditTrail;
import io.fluxcapacitor.common.api.search.DocumentStats;
import io.fluxcapacitor.common.api.search.DocumentUpdate;
import io.fluxcapacitor.common.api.search.GetDocument;
import io.fluxcapacitor.common.api.search.GetSearchHistogram;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InMemorySearchClient
implements SearchClient {
    private final List<Document> documents = new CopyOnWriteArrayList<Document>();

    @Override
    public synchronized CompletableFuture<Void> index(List<SerializedDocument> documents, Guarantee guarantee, boolean ifNotExists) {
        Function<Document, String> identify = d -> d.getCollection() + "/" + d.getId();
        Map existing = this.documents.stream().collect(Collectors.toMap(identify, Function.identity()));
        Map updates = documents.stream().map(SerializedDocument::deserializeDocument).collect(Collectors.toMap(identify, Function.identity(), (a, b) -> b, LinkedHashMap::new));
        if (ifNotExists) {
            updates.entrySet().stream().filter(e -> !existing.containsKey(e.getKey())).forEach(e -> this.documents.add((Document)e.getValue()));
        } else {
            updates.forEach((key, value) -> {
                Optional.ofNullable((Document)existing.get(key)).ifPresent(this.documents::remove);
                this.documents.add((Document)value);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Stream<SearchHit<SerializedDocument>> search(SearchDocuments searchDocuments, int fetchSize) {
        SearchQuery query = searchDocuments.getQuery();
        Stream<Document> documentStream = this.documents.stream().filter(arg_0 -> ((SearchQuery)query).matches(arg_0));
        documentStream = documentStream.sorted(Document.createComparator((SearchDocuments)searchDocuments));
        if (!searchDocuments.getPathFilters().isEmpty()) {
            Predicate pathFilter = searchDocuments.computePathFilter();
            documentStream = documentStream.map(d -> d.filterPaths(pathFilter));
        }
        if (searchDocuments.getSkip() > 0) {
            documentStream = documentStream.skip(searchDocuments.getSkip());
        }
        if (searchDocuments.getLastHit() != null) {
            documentStream = documentStream.dropWhile(d -> !d.getId().equals(searchDocuments.getLastHit().getId())).skip(1L);
        }
        if (searchDocuments.getMaxSize() != null) {
            documentStream = documentStream.limit(searchDocuments.getMaxSize().intValue());
        }
        return documentStream.map(d -> new SearchHit<SerializedDocument>(d.getId(), d.getCollection(), d.getTimestamp(), d.getEnd(), () -> new SerializedDocument(d)));
    }

    @Override
    public Optional<SerializedDocument> fetch(GetDocument r) {
        return this.documents.stream().filter(d -> Objects.equals(r.getId(), d.getId()) && Objects.equals(r.getCollection(), d.getCollection())).findFirst().map(SerializedDocument::new);
    }

    @Override
    public CompletableFuture<Void> delete(SearchQuery query, Guarantee guarantee) {
        this.documents.removeAll(this.documents.stream().filter(arg_0 -> ((SearchQuery)query).matches(arg_0)).toList());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> delete(String documentId, String collection, Guarantee guarantee) {
        this.documents.removeIf(d -> Objects.equals(documentId, d.getId()) && Objects.equals(collection, d.getCollection()));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> createAuditTrail(CreateAuditTrail request) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> deleteCollection(String collection, Guarantee guarantee) {
        this.documents.removeIf(d -> Objects.equals(collection, d.getCollection()));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public List<DocumentStats> fetchStatistics(SearchQuery query, List<String> fields, List<String> groupBy) {
        return DocumentStats.compute(this.documents.stream().filter(arg_0 -> ((SearchQuery)query).matches(arg_0)), fields, groupBy);
    }

    @Override
    public SearchHistogram fetchHistogram(GetSearchHistogram request) {
        SearchQuery query = request.getQuery();
        List results = IntStream.range(0, request.getResolution()).mapToLong(i -> 0L).boxed().collect(Collectors.toList());
        if (query.getSince() == null) {
            return new SearchHistogram(query.getSince(), query.getBefore(), results);
        }
        if (query.getBefore() == null) {
            query = query.toBuilder().before(Instant.now()).build();
        }
        long min = query.getSince().toEpochMilli();
        long delta = query.getBefore().toEpochMilli() - min;
        long step = Math.min(1L, delta / (long)request.getResolution());
        this.search(SearchDocuments.builder().query(query).build(), -1).map(h -> ((SerializedDocument)h.getValue()).deserializeDocument()).collect(Collectors.groupingBy(d -> (d.getTimestamp().toEpochMilli() - min) / step)).forEach((bucket, hits) -> results.set(bucket.intValue(), Long.valueOf(hits.size())));
        return new SearchHistogram(query.getSince(), query.getBefore(), results);
    }

    @Override
    public CompletableFuture<Void> bulkUpdate(Collection<DocumentUpdate> updates, Guarantee guarantee) {
        updates.forEach(action -> {
            switch (action.getType()) {
                case delete: {
                    this.delete(action.getId(), action.getCollection(), guarantee);
                    break;
                }
                case index: 
                case indexIfNotExists: {
                    this.index(List.of(action.getObject()), guarantee, action.getType().equals((Object)BulkUpdate.Type.indexIfNotExists));
                }
            }
        });
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void close() {
    }
}

