/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search;

import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.DocumentStats;
import io.fluxcapacitor.common.api.search.Group;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.constraints.AllConstraint;
import io.fluxcapacitor.common.api.search.constraints.AnyConstraint;
import io.fluxcapacitor.common.api.search.constraints.BetweenConstraint;
import io.fluxcapacitor.common.api.search.constraints.ExistsConstraint;
import io.fluxcapacitor.common.api.search.constraints.LookAheadConstraint;
import io.fluxcapacitor.common.api.search.constraints.MatchConstraint;
import io.fluxcapacitor.common.api.search.constraints.NotConstraint;
import io.fluxcapacitor.common.api.search.constraints.QueryConstraint;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.persisting.search.GroupSearch;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Search {
    default public Search since(Instant start) {
        return this.inPeriod(start, null);
    }

    default public Search before(Instant endExclusive) {
        return this.inPeriod(null, endExclusive);
    }

    default public Search beforeLast(Duration period) {
        return this.before(FluxCapacitor.currentTime().minus(period));
    }

    default public Search inLast(Duration period) {
        return this.since(FluxCapacitor.currentTime().minus(period));
    }

    default public Search inPeriod(Instant start, Instant endExclusive) {
        return this.inPeriod(start, endExclusive, false);
    }

    public Search inPeriod(Instant var1, Instant var2, boolean var3);

    default public Search lookAhead(String phrase, String ... paths) {
        return this.constraint(LookAheadConstraint.lookAhead((String)phrase, (String[])paths));
    }

    default public Search query(String phrase, String ... paths) {
        return this.constraint(QueryConstraint.query((String)phrase, (String[])paths));
    }

    default public Search match(Object constraint, String ... paths) {
        return this.match(constraint, false, paths);
    }

    default public Search match(Object constraint, boolean strict, String ... paths) {
        return this.constraint(MatchConstraint.match((Object)constraint, (boolean)strict, (String[])paths));
    }

    default public Search anyExist(String ... paths) {
        return switch (paths.length) {
            case 0 -> this;
            case 1 -> this.constraint(ExistsConstraint.exists((String)paths[0]));
            default -> this.constraint(AnyConstraint.any((Collection)Arrays.stream(paths).map(ExistsConstraint::exists).collect(Collectors.toList())));
        };
    }

    default public Search atLeast(Number min, String path) {
        return this.between(min, null, path);
    }

    default public Search below(Number max, String path) {
        return this.between(null, max, path);
    }

    default public Search between(Number min, Number maxExclusive, String path) {
        return this.constraint(new Constraint[]{BetweenConstraint.between((Object)min, (Object)maxExclusive, (String)path)});
    }

    default public Search all(Constraint ... constraints) {
        return this.constraint(AllConstraint.all((Constraint[])constraints));
    }

    default public Search any(Constraint ... constraints) {
        return this.constraint(AnyConstraint.any((Constraint[])constraints));
    }

    default public Search not(Constraint constraint) {
        return this.constraint(new Constraint[]{NotConstraint.not((Constraint)constraint)});
    }

    public Search constraint(Constraint ... var1);

    default public Search sortByTimestamp() {
        return this.sortByTimestamp(false);
    }

    public Search sortByTimestamp(boolean var1);

    public Search sortByScore();

    default public Search sortBy(String path) {
        return this.sortBy(path, false);
    }

    public Search sortBy(String var1, boolean var2);

    public Search exclude(String ... var1);

    public Search includeOnly(String ... var1);

    public Search skip(Integer var1);

    public <T> List<T> fetch(int var1);

    public <T> List<T> fetch(int var1, Class<T> var2);

    default public <T> List<T> fetchAll() {
        return this.stream().collect(Collectors.toList());
    }

    default public <T> List<T> fetchAll(Class<T> type) {
        return this.stream(type).collect(Collectors.toList());
    }

    default public <T> Optional<T> fetchFirst() {
        return this.fetch(1).stream().findFirst();
    }

    default public <T> Optional<T> fetchFirst(Class<T> type) {
        return this.fetch(1, type).stream().findFirst();
    }

    default public <T> Stream<T> stream() {
        return this.streamHits().map(SearchHit::getValue);
    }

    default public <T> Stream<T> stream(int fetchSize) {
        return this.streamHits(fetchSize).map(SearchHit::getValue);
    }

    default public <T> Stream<T> stream(Class<T> type) {
        return this.streamHits(type).map(SearchHit::getValue);
    }

    default public <T> Stream<T> stream(Class<T> type, int fetchSize) {
        return this.streamHits(type, fetchSize).map(SearchHit::getValue);
    }

    public <T> Stream<SearchHit<T>> streamHits();

    public <T> Stream<SearchHit<T>> streamHits(int var1);

    public <T> Stream<SearchHit<T>> streamHits(Class<T> var1);

    public <T> Stream<SearchHit<T>> streamHits(Class<T> var1, int var2);

    public SearchHistogram fetchHistogram(int var1, int var2);

    public GroupSearch groupBy(String ... var1);

    default public Long count() {
        return this.aggregate(new String[0]).values().stream().findFirst().map(DocumentStats.FieldStats::getCount).orElse(0L);
    }

    default public Map<String, DocumentStats.FieldStats> aggregate(String ... fields) {
        return this.groupBy(new String[0]).aggregate(fields).get(Group.of((String[])new String[0]));
    }

    public CompletableFuture<Void> delete();
}

