/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.ConsistentHashing;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.EventPublicationStrategy;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingException;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventStore
implements EventStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultEventStore.class);
    private final EventStoreClient client;
    private final GatewayClient eventGateway;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public CompletableFuture<Void> storeEvents(Object aggregateId, List<?> events, EventPublicationStrategy strategy) {
        CompletableFuture<Void> result;
        ArrayList messages = new ArrayList(events.size());
        try {
            int segment = ConsistentHashing.computeSegment((String)aggregateId.toString());
            events.forEach(e -> {
                DeserializingMessage deserializingMessage;
                if (e instanceof DeserializingMessage) {
                    deserializingMessage = (DeserializingMessage)e;
                } else {
                    SerializedMessage serializedMessage;
                    Message m = this.dispatchInterceptor.interceptDispatch(Message.asMessage(e), MessageType.EVENT);
                    SerializedMessage serializedMessage2 = serializedMessage = m == null ? null : this.dispatchInterceptor.modifySerializedMessage(m.serialize(this.serializer), m, MessageType.EVENT);
                    if (serializedMessage == null) {
                        return;
                    }
                    deserializingMessage = new DeserializingMessage(serializedMessage, type -> m.getPayload(), MessageType.EVENT);
                }
                messages.add(deserializingMessage);
            });
            Stream<SerializedMessage> serializedEvents = messages.stream().map(m -> m.getSerializedObject().getSegment() == null ? m.getSerializedObject().withSegment(Integer.valueOf(segment)) : m.getSerializedObject());
            result = switch (strategy) {
                default -> throw new IncompatibleClassChangeError();
                case EventPublicationStrategy.STORE_AND_PUBLISH -> this.client.storeEvents(aggregateId.toString(), serializedEvents.toList(), false);
                case EventPublicationStrategy.STORE_ONLY -> this.client.storeEvents(aggregateId.toString(), serializedEvents.toList(), true);
                case EventPublicationStrategy.PUBLISH_ONLY -> this.eventGateway.send(Guarantee.STORED, (SerializedMessage[])serializedEvents.toArray(SerializedMessage[]::new));
            };
        }
        catch (Exception e2) {
            throw new EventSourcingException(String.format("Failed to store events %s for aggregate %s", events.stream().map(DefaultEventStore::payloadName).collect(Collectors.toList()), aggregateId), e2);
        }
        switch (strategy) {
            case STORE_AND_PUBLISH: 
            case PUBLISH_ONLY: {
                messages.forEach(this.localHandlerRegistry::handle);
            }
        }
        return result;
    }

    private static String payloadName(Object event) {
        return event instanceof Message ? ((Message)event).getPayloadClass().getSimpleName() : (event == null ? "null" : event.getClass().getSimpleName());
    }

    @Override
    public AggregateEventStream<DeserializingMessage> getEvents(Object aggregateId, long lastSequenceNumber, boolean ignoreUnknownType) {
        try {
            AggregateEventStream<SerializedMessage> serializedEvents = this.client.getEvents(aggregateId.toString(), lastSequenceNumber);
            return serializedEvents.convert(stream -> this.serializer.deserializeMessages((Stream<SerializedMessage>)stream, MessageType.EVENT, !ignoreUnknownType));
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to obtain events for aggregate %s", aggregateId), e);
        }
    }

    @ConstructorProperties(value={"client", "eventGateway", "serializer", "dispatchInterceptor", "localHandlerRegistry"})
    public DefaultEventStore(EventStoreClient client, GatewayClient eventGateway, Serializer serializer, DispatchInterceptor dispatchInterceptor, HandlerRegistry localHandlerRegistry) {
        this.client = client;
        this.eventGateway = eventGateway;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.localHandlerRegistry = localHandlerRegistry;
    }

    public Optional<CompletableFuture<Message>> handle(DeserializingMessage message) {
        return this.localHandlerRegistry.handle(message);
    }

    public HandlerRegistry merge(HandlerRegistry next) {
        return this.localHandlerRegistry.merge(next);
    }

    @Override
    public Registration registerHandler(Object target) {
        return this.localHandlerRegistry.registerHandler(target);
    }

    @Override
    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        return this.localHandlerRegistry.registerHandler(target, handlerFilter);
    }
}

