/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.caching;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.CacheEvictionEvent;
import java.beans.ConstructorProperties;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(DefaultCache.class);
    protected static final String mutexPrecursor = "$DC$";
    final Map<Object, CacheReference> valueMap;
    private final Executor evictionNotifier;
    private final Collection<Consumer<CacheEvictionEvent>> evictionListeners = new CopyOnWriteArrayList<Consumer<CacheEvictionEvent>>();
    private final ExecutorService referencePurger = Executors.newSingleThreadExecutor(ObjectUtils.newThreadFactory((String)"DefaultCache-referencePurger"));
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();

    public DefaultCache() {
        this(1000000);
    }

    public DefaultCache(int maxSize) {
        this(maxSize, (Executor)Executors.newSingleThreadExecutor(ObjectUtils.newThreadFactory((String)"DefaultCache-evictionNotifier")));
    }

    public DefaultCache(final int maxSize, Executor evictionNotifier) {
        this.valueMap = Collections.synchronizedMap(new LinkedHashMap<Object, CacheReference>(Math.min(128, maxSize), 0.75f, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, CacheReference> eldest) {
                boolean remove = this.size() > maxSize;
                try {
                    boolean bl = remove;
                    return bl;
                }
                finally {
                    if (remove) {
                        DefaultCache.this.notifyEvictionListeners(eldest.getKey(), CacheEvictionEvent.Reason.size);
                    }
                }
            }
        });
        this.evictionNotifier = evictionNotifier;
        this.referencePurger.execute(this::pollReferenceQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T compute(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        String string = (mutexPrecursor + id).intern();
        synchronized (string) {
            CacheReference previous = this.valueMap.get(id);
            CacheReference next = this.wrap(id, mappingFunction.apply(id, this.unwrap(previous)));
            if (next == null) {
                this.valueMap.remove(id);
                if (previous != null && previous.get() != null) {
                    this.notifyEvictionListeners(id, CacheEvictionEvent.Reason.manual);
                }
            } else {
                this.valueMap.put(id, next);
            }
            return this.unwrap(next);
        }
    }

    @Override
    public Object put(Object id, Object value) {
        return this.compute(id, (k, v) -> value == null ? Optional.empty() : value);
    }

    @Override
    public Object putIfAbsent(Object id, Object value) {
        return this.computeIfAbsent(id, k -> value == null ? Optional.empty() : value);
    }

    @Override
    public <T> T computeIfAbsent(Object id, Function<? super Object, T> mappingFunction) {
        return (T)this.compute(id, (k, v) -> v == null ? mappingFunction.apply(k) : v);
    }

    @Override
    public <T> T computeIfPresent(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return (T)this.compute(id, (k, v) -> v == null ? null : mappingFunction.apply(k, v));
    }

    @Override
    public <T> T remove(Object id) {
        return (T)this.compute(id, (k, v) -> null);
    }

    @Override
    public <T> T get(Object id) {
        return this.unwrap(this.valueMap.get(id));
    }

    @Override
    public boolean containsKey(Object id) {
        return this.valueMap.containsKey(id);
    }

    @Override
    public void clear() {
        this.valueMap.clear();
        this.notifyEvictionListeners(null, CacheEvictionEvent.Reason.manual);
    }

    @Override
    public int size() {
        return this.valueMap.size();
    }

    @Override
    public Registration registerEvictionListener(Consumer<CacheEvictionEvent> listener) {
        this.evictionListeners.add(listener);
        return () -> this.evictionListeners.remove(listener);
    }

    @Override
    public void close() {
        try {
            Executor executor = this.evictionNotifier;
            if (executor instanceof ExecutorService) {
                ExecutorService executorService = (ExecutorService)executor;
                executorService.shutdownNow();
            }
            this.referencePurger.shutdownNow();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected CacheReference wrap(Object id, Object value) {
        return value == null ? null : new CacheReference(id, value);
    }

    protected <T> T unwrap(CacheReference ref) {
        if (ref == null) {
            return null;
        }
        Object result = ref.get();
        if (result instanceof Optional) {
            result = ((Optional)result).orElse(null);
        }
        return result;
    }

    protected void pollReferenceQueue() {
        try {
            Reference<Object> reference;
            while ((reference = this.referenceQueue.remove()) != null) {
                if (!(reference instanceof CacheReference)) continue;
                CacheReference cacheReference = (CacheReference)reference;
                this.remove(cacheReference.id);
                this.notifyEvictionListeners(cacheReference.id, CacheEvictionEvent.Reason.memoryPressure);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void notifyEvictionListeners(Object id, CacheEvictionEvent.Reason reason) {
        CacheEvictionEvent event = new CacheEvictionEvent(id, reason);
        this.evictionNotifier.execute(() -> this.evictionListeners.forEach(l -> l.accept(event)));
    }

    @ConstructorProperties(value={"valueMap", "evictionNotifier"})
    public DefaultCache(Map<Object, CacheReference> valueMap, Executor evictionNotifier) {
        this.valueMap = valueMap;
        this.evictionNotifier = evictionNotifier;
    }

    protected class CacheReference
    extends SoftReference<Object> {
        private final Object id;

        public CacheReference(Object id, Object value) {
            super(value, DefaultCache.this.referenceQueue);
            this.id = id;
        }
    }
}

