/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Pair;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Invocation;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.DelegatingEntity;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityHelper;
import io.fluxcapacitor.javaclient.modeling.EventPublication;
import io.fluxcapacitor.javaclient.modeling.ImmutableEntity;
import io.fluxcapacitor.javaclient.modeling.ModifiableEntity;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ModifiableAggregateRoot<T>
extends DelegatingEntity<T> {
    private static final ThreadLocal<Map<Object, ModifiableAggregateRoot<?>>> activeAggregates = ThreadLocal.withInitial(HashMap::new);
    private Entity<T> lastCommitted;
    private Entity<T> lastStable;
    private final boolean commitInBatch;
    private final EventPublication eventPublication;
    private final EntityHelper entityHelper;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final CommitHandler commitHandler;
    private final AtomicBoolean waitingForHandlerEnd = new AtomicBoolean();
    private final AtomicBoolean waitingForBatchEnd = new AtomicBoolean();
    private final List<DeserializingMessage> applied = new ArrayList<DeserializingMessage>();
    private final List<DeserializingMessage> uncommitted = new ArrayList<DeserializingMessage>();
    private final List<Pair<Message, Boolean>> queued = new ArrayList<Pair<Message, Boolean>>();
    private volatile boolean applying;

    public static <T> Optional<ModifiableAggregateRoot<T>> getIfActive(Object aggregateId) {
        return Optional.ofNullable(activeAggregates.get().get(aggregateId));
    }

    public static <T> ModifiableAggregateRoot<T> load(Object aggregateId, Supplier<ImmutableEntity<T>> loader, boolean commitInBatch, EventPublication eventPublication, Serializer serializer, DispatchInterceptor dispatchInterceptor, CommitHandler commitHandler) {
        return ModifiableAggregateRoot.getIfActive(aggregateId).orElseGet(() -> new ModifiableAggregateRoot((ImmutableEntity)loader.get(), commitInBatch, eventPublication, serializer, dispatchInterceptor, commitHandler));
    }

    protected ModifiableAggregateRoot(ImmutableEntity<T> delegate, boolean commitInBatch, EventPublication eventPublication, Serializer serializer, DispatchInterceptor dispatchInterceptor, CommitHandler commitHandler) {
        super(delegate);
        this.entityHelper = delegate.entityHelper();
        this.lastCommitted = delegate;
        this.lastStable = delegate;
        this.commitInBatch = commitInBatch;
        this.eventPublication = eventPublication;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.commitHandler = commitHandler;
    }

    @Override
    public <E extends Exception> ModifiableAggregateRoot<T> assertLegal(Object command) throws E {
        this.entityHelper.intercept(command, this).forEach(c -> this.entityHelper.assertLegal(c, this));
        return this;
    }

    @Override
    public ModifiableAggregateRoot<T> assertAndApply(Object payloadOrMessage) {
        this.entityHelper.intercept(payloadOrMessage, this).forEach(m -> this.apply(Message.asMessage(m), true));
        return this;
    }

    @Override
    public ModifiableAggregateRoot<T> apply(Message message) {
        this.entityHelper.intercept(message, this).forEach(m -> this.apply(Message.asMessage(m), false));
        return this;
    }

    protected ModifiableAggregateRoot<T> apply(Message message, boolean assertLegal) {
        if (this.applying) {
            this.queued.add((Pair<Message, Boolean>)new Pair((Object)message, (Object)assertLegal));
            return this;
        }
        if (assertLegal) {
            this.entityHelper.assertLegal(message, this);
        }
        try {
            this.applying = true;
            this.handleUpdate(a -> {
                Entity result;
                block8: {
                    int hashCodeBefore = this.eventPublication == EventPublication.IF_MODIFIED ? (a.get() == null ? -1 : a.get().hashCode()) : -1;
                    result = a.apply((Object)new DeserializingMessage(message, MessageType.EVENT, this.serializer));
                    switch (this.eventPublication) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case ALWAYS: {
                            break;
                        }
                        case IF_MODIFIED: {
                            if (!Objects.equals(a.get(), result.get()) || result.get() != null && result.get().hashCode() != hashCodeBefore) {
                                break;
                            }
                            break block8;
                        }
                        case NEVER: {
                            break block8;
                        }
                    }
                    Message intercepted = this.dispatchInterceptor.interceptDispatch(message, MessageType.EVENT);
                    if (intercepted == null) {
                        return a;
                    }
                    Message m = intercepted.addMetadata("$aggregateId", this.id().toString(), "$aggregateType", this.type().getName(), "$sequenceNumber", String.valueOf(this.getDelegate().sequenceNumber() + 1L));
                    SerializedMessage serializedEvent = this.dispatchInterceptor.modifySerializedMessage(m.serialize(this.serializer), m, MessageType.EVENT);
                    if (serializedEvent == null) {
                        return a;
                    }
                    this.applied.add(new DeserializingMessage(serializedEvent, type -> this.serializer.convert(m.getPayload(), type), MessageType.EVENT));
                }
                return result;
            });
        }
        finally {
            this.applying = false;
        }
        while (!this.queued.isEmpty()) {
            Pair<Message, Boolean> value = this.queued.remove(0);
            this.apply((Message)value.getFirst(), (Boolean)value.getSecond());
        }
        return this;
    }

    @Override
    public ModifiableAggregateRoot<T> update(UnaryOperator<T> function) {
        this.handleUpdate(a -> a.update(function));
        return this;
    }

    @Override
    public Collection<? extends Entity<?>> entities() {
        return super.entities().stream().map(e -> new ModifiableEntity(e, this)).collect(Collectors.toList());
    }

    @Override
    public Entity<T> previous() {
        Entity previous = this.delegate.previous();
        return previous == null ? null : new ModifiableEntity(previous, this);
    }

    protected void handleUpdate(UnaryOperator<Entity<T>> update) {
        boolean firstUpdate = this.waitingForHandlerEnd.compareAndSet(false, true);
        if (firstUpdate) {
            activeAggregates.get().putIfAbsent(this.id(), this);
        }
        try {
            this.delegate = (Entity)update.apply(this.getDelegate());
        }
        finally {
            if (firstUpdate) {
                Invocation.whenHandlerCompletes((r, e) -> this.whenHandlerCompletes((Throwable)e));
            }
        }
    }

    protected void whenHandlerCompletes(Throwable error) {
        this.waitingForHandlerEnd.set(false);
        if (error == null) {
            this.uncommitted.addAll(this.applied);
            this.applied.clear();
            this.lastStable = this.getDelegate();
            if (!this.commitInBatch) {
                this.commit();
            } else if (this.waitingForBatchEnd.compareAndSet(false, true)) {
                DeserializingMessage.whenBatchCompletes(e -> this.commit());
            }
        } else {
            this.applied.clear();
            this.delegate = this.lastStable;
            if (!this.commitInBatch) {
                activeAggregates.get().remove(this.id(), this);
            } else if (this.waitingForBatchEnd.compareAndSet(false, true)) {
                DeserializingMessage.whenBatchCompletes(e -> this.commit());
            }
        }
    }

    protected void commit() {
        activeAggregates.get().remove(this.id(), this);
        ArrayList<DeserializingMessage> events = new ArrayList<DeserializingMessage>(this.uncommitted);
        this.uncommitted.clear();
        this.waitingForBatchEnd.set(false);
        this.commitHandler.handle(this.lastStable, events, this.lastCommitted);
        this.lastCommitted = this.lastStable;
    }

    @Override
    public String toString() {
        return "ModifiableAggregateRoot()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifiableAggregateRoot)) {
            return false;
        }
        ModifiableAggregateRoot other = (ModifiableAggregateRoot)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifiableAggregateRoot;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @FunctionalInterface
    public static interface CommitHandler {
        public void handle(Entity<?> var1, List<DeserializingMessage> var2, Entity<?> var3);
    }
}

