/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import lombok.NonNull;

public abstract class Id<T> {
    @JsonValue
    String functionalId;
    Class<T> type;
    String repositoryId;

    protected Id(Object functionalId, Class<T> type) {
        this(functionalId, type, "");
    }

    protected Id(Object functionalId, Class<T> type, String prefix) {
        this(functionalId, type, prefix, true);
    }

    protected Id(Object functionalId, Class<T> type, boolean caseSensitive) {
        this(functionalId, type, "", caseSensitive);
    }

    protected Id(@NonNull Object functionalId, @NonNull Class<T> type, @NonNull String prefix, boolean caseSensitive) {
        if (functionalId == null) {
            throw new NullPointerException("functionalId is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.functionalId = functionalId.toString();
        this.type = type;
        this.repositoryId = caseSensitive ? prefix + this.functionalId : prefix + this.functionalId.toLowerCase();
    }

    public final String toString() {
        return this.repositoryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id id = (Id)o;
        return this.functionalId.equals(id.functionalId) && this.type.equals(id.type) && this.repositoryId.equals(id.repositoryId);
    }

    public int hashCode() {
        return Objects.hash(this.functionalId, this.type, this.repositoryId);
    }

    public String getFunctionalId() {
        return this.functionalId;
    }

    public Class<T> getType() {
        return this.type;
    }
}

