/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.javaclient.configuration.client.AbstractClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.InMemoryEventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.InMemoryKeyValueClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.InMemorySearchClient;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.InMemorySchedulingClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.InMemoryMessageStore;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.function.Function;

public class InMemoryClient
extends AbstractClient {
    private static Function<MessageType, InMemoryMessageStore> messageStoreFactory(Duration messageExpiration) {
        InMemoryEventStoreClient eventStoreClient = new InMemoryEventStoreClient(messageExpiration);
        return ObjectUtils.memoize(t -> switch (t) {
            case MessageType.NOTIFICATION, MessageType.EVENT -> eventStoreClient;
            case MessageType.SCHEDULE -> new InMemorySchedulingClient(messageExpiration);
            default -> new InMemoryMessageStore((MessageType)t, messageExpiration);
        });
    }

    public static InMemoryClient newInstance() {
        return new InMemoryClient(Duration.ofMinutes(2L));
    }

    public static InMemoryClient newInstance(Duration messageExpiration) {
        return new InMemoryClient(messageExpiration);
    }

    protected InMemoryClient(Duration messageExpiration) {
        this("inMemory", ManagementFactory.getRuntimeMXBean().getName(), InMemoryClient.messageStoreFactory(messageExpiration), new InMemoryKeyValueClient(), new InMemorySearchClient());
    }

    protected <T extends GatewayClient & TrackingClient> InMemoryClient(String name, String id, Function<MessageType, T> messageStoreClients, KeyValueClient keyValueClient, SearchClient searchClient) {
        super(name, id, messageStoreClients, messageStoreClients, (EventStoreClient)messageStoreClients.apply(MessageType.EVENT), (SchedulingClient)messageStoreClients.apply(MessageType.SCHEDULE), keyValueClient, searchClient);
    }
}

