/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.CachingTrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.WeakHashMap;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(TestClient.class);
    private final Map<Object, Object> spiedComponents = new WeakHashMap<Object, Object>();
    private final Client delegate;

    protected <T> T decorate(T component) {
        return (T)this.spiedComponents.computeIfAbsent(component, Mockito::spy);
    }

    public void resetMocks() {
        this.spiedComponents.values().forEach(xva$0 -> Mockito.reset((Object[])new Object[]{xva$0}));
    }

    public String name() {
        return this.delegate.name();
    }

    public String id() {
        return this.delegate.id();
    }

    public GatewayClient getGatewayClient(MessageType messageType) {
        return this.decorate(this.delegate.getGatewayClient(messageType));
    }

    public TrackingClient getTrackingClient(MessageType messageType) {
        TrackingClient component = this.delegate.getTrackingClient(messageType);
        if (component instanceof CachingTrackingClient && !this.spiedComponents.containsKey(component)) {
            ReflectionUtils.setField((String)"delegate", (Object)component, (Object)this.decorate(((CachingTrackingClient)component).getDelegate()));
        }
        return this.decorate(component);
    }

    public EventStoreClient getEventStoreClient() {
        return this.decorate(this.delegate.getEventStoreClient());
    }

    public SchedulingClient getSchedulingClient() {
        return this.decorate(this.delegate.getSchedulingClient());
    }

    public KeyValueClient getKeyValueClient() {
        return this.decorate(this.delegate.getKeyValueClient());
    }

    public SearchClient getSearchClient() {
        return this.decorate(this.delegate.getSearchClient());
    }

    public void shutDown() {
        this.delegate.shutDown();
    }

    public Registration beforeShutdown(Runnable task) {
        return this.delegate.beforeShutdown(task);
    }

    @ConstructorProperties(value={"delegate"})
    public TestClient(Client delegate) {
        this.delegate = delegate;
    }

    public Client getDelegate() {
        return this.delegate;
    }
}

