/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.benchmark;

import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.DefaultMemberInvoker;
import io.fluxcapacitor.common.reflection.MemberInvoker;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

class MethodInvokerBenchmark {
    private static final long iterations = 100000000L;
    private static final int WARM_UP = 2;

    MethodInvokerBenchmark() {
    }

    public static void main(String[] args) throws Throwable {
        Person target = new Person("Ann");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Method method = Person.class.getDeclaredMethod("name", new Class[0]);
        MethodHandle realMethodHandle = lookup.unreflect(method);
        MemberInvoker invoker = DefaultMemberInvoker.asInvoker((Member)method);
        Handler fluxHandler = HandlerInspector.createHandler((Object)target, Handle.class);
        HandlerInvoker fluxInvoker = (HandlerInvoker)fluxHandler.findInvoker(null).orElseThrow();
        System.out.println("Invocation result of lambda: " + invoker.invoke((Object)target));
        System.out.println("warming up");
        for (int i = 0; i < 2; ++i) {
            MethodInvokerBenchmark.testDirect(target);
            MethodInvokerBenchmark.testInvoker(invoker, target);
            MethodInvokerBenchmark.testMessageHandle(realMethodHandle, target);
            MethodInvokerBenchmark.testReflection(method, target);
            MethodInvokerBenchmark.testFluxInvoker(fluxInvoker);
            MethodInvokerBenchmark.testFluxHandler((Handler<Object>)fluxHandler);
        }
        System.out.println("starting");
        TimingUtils.time(() -> MethodInvokerBenchmark.testDirect(target), ms -> System.out.printf("direct: %dms, ", ms));
        TimingUtils.time(() -> MethodInvokerBenchmark.testReflection(method, target), ms -> System.out.printf("reflection: %dms, ", ms));
        TimingUtils.time(() -> MethodInvokerBenchmark.testMessageHandle(realMethodHandle, target), ms -> System.out.printf("method handle: %dms, ", ms));
        TimingUtils.time(() -> MethodInvokerBenchmark.testInvoker(invoker, target), ms -> System.out.printf("lambda invoker: %dms, ", ms));
        TimingUtils.time(() -> MethodInvokerBenchmark.testFluxInvoker(fluxInvoker), elapsed -> System.out.printf("flux invoker: %dms, ", elapsed), (TemporalUnit)ChronoUnit.MILLIS);
        TimingUtils.time(() -> MethodInvokerBenchmark.testFluxHandler((Handler<Object>)fluxHandler), ms -> System.out.printf("flux handler: %dms, ", ms));
    }

    private static void testFluxInvoker(HandlerInvoker invoker) {
        for (long i = 0L; i < 100000000L; ++i) {
            invoker.invoke();
        }
    }

    private static void testDirect(Person target) {
        for (long i = 0L; i < 100000000L; ++i) {
            target.name();
        }
    }

    private static void testInvoker(MemberInvoker invoker, Person target) {
        for (long i = 0L; i < 100000000L; ++i) {
            invoker.invoke((Object)target);
        }
    }

    private static void testFluxHandler(Handler<Object> handler) {
        for (long i = 0L; i < 100000000L; ++i) {
            ((HandlerInvoker)handler.findInvoker(null).orElseThrow()).invoke();
        }
    }

    private static void testReflection(Method method, Person target) {
        for (long i = 0L; i < 100000000L; ++i) {
            method.invoke((Object)target, new Object[0]);
        }
    }

    private static void testMessageHandle(MethodHandle mh, Person target) {
        for (long i = 0L; i < 100000000L; ++i) {
            String string = mh.invokeExact(target);
        }
    }

    static class Person {
        private long i = 0L;
        private final String name;

        public Person(String name) {
            this.name = name;
        }

        @Handle
        private String name() {
            ++this.i;
            return this.name;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Handle {
    }
}

