/*
 * Decompiled with CFR 0.152.
 */
package io.fency.sample;

import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SampleApplicationRunner
implements ApplicationRunner {
    private final RabbitTemplate rabbitTemplate;

    public SampleApplicationRunner(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public void run(ApplicationArguments args) {
        for (int i = 1; i <= 5; ++i) {
            String messageWithUniqueId = this.concat(i, "hello world");
            this.sendMessage(messageWithUniqueId);
            Message messageWithFixedId = this.createMessageWithFixedId(this.concat(i, "message"));
            this.sendMessage(messageWithFixedId);
        }
    }

    private String concat(int i, String message) {
        return String.join((CharSequence)"-", message, String.valueOf(i));
    }

    private void sendMessage(Object body) {
        this.rabbitTemplate.convertAndSend(body);
    }

    private Message createMessageWithFixedId(String message) {
        byte[] body = message.getBytes(Charset.defaultCharset());
        MessageProperties properties = new MessageProperties();
        properties.setTimestamp(Date.from(LocalDateTime.now().toInstant(ZoneOffset.UTC)));
        properties.setMessageId("12345");
        properties.setConsumerQueue("myQueue");
        properties.setType(String.class.getName());
        properties.setContentType("text/plain");
        return MessageBuilder.withBody((byte[])body).andProperties(properties).build();
    }
}

