/*
 * Decompiled with CFR 0.152.
 */
package io.fency.sample;

import io.fency.sample.MessageListener;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.amqp.rabbit.transaction.RabbitTransactionManager;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
public class RabbitSpringConfig {
    private static final String EXCHANGE = "myExchange";

    @Bean
    public RabbitTransactionManager transactionManager(ConnectionFactory connectionFactory) {
        return new RabbitTransactionManager(connectionFactory);
    }

    @Bean
    public SimpleMessageConverter messageConverter() {
        SimpleMessageConverter messageConverter = new SimpleMessageConverter();
        messageConverter.setCreateMessageIds(true);
        return messageConverter;
    }

    @Bean
    public MessageListener messageListener() {
        return new MessageListener();
    }

    @Bean
    public SimpleMessageListenerContainer messageListenerContainer(AmqpAdmin admin, CachingConnectionFactory cachingConnectionFactory, MessageListener messageListener, TransactionInterceptor interceptor, PlatformTransactionManager transactionManager) {
        Queue queue = new Queue("myQueue", false);
        this.declareExchangeAndQueue(admin, queue);
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer((ConnectionFactory)cachingConnectionFactory);
        container.setQueues(new Queue[]{queue});
        container.setMessageListener((org.springframework.amqp.core.MessageListener)new MessageListenerAdapter((Object)messageListener));
        container.setAdviceChain(new Advice[]{interceptor});
        container.setConcurrentConsumers(5);
        container.setTransactionManager(transactionManager);
        return container;
    }

    private void declareExchangeAndQueue(AmqpAdmin admin, Queue queue) {
        TopicExchange exchange = new TopicExchange(EXCHANGE, true, false);
        admin.declareQueue(queue);
        admin.declareExchange((Exchange)exchange);
        admin.declareBinding(BindingBuilder.bind((Queue)queue).to(exchange).with("#"));
    }
}

