/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.traffic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.validation.ValidationError;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.configuration.TrafficRecordingOptions;
import io.evitadb.core.EvitaInternalSessionContract;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceQueryRecordingInstrumentation
extends SimplePerformantInstrumentation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceQueryRecordingInstrumentation.class);
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final TrafficRecordingOptions trafficRecordingOptions;

    @Nullable
    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return this.logFailedSourceQuery(parameters);
    }

    @Nullable
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters, InstrumentationState state) {
        return this.logFailedSourceQuery((InstrumentationExecutionParameters)parameters);
    }

    @Nonnull
    private <T> InstrumentationContext<T> logFailedSourceQuery(final InstrumentationExecutionParameters parameters) {
        final EvitaInternalSessionContract internalSession = this.getInternalSession(parameters.getGraphQLContext());
        if (internalSession == null) {
            return SimpleInstrumentationContext.noOp();
        }
        return new SimpleInstrumentationContext<T>(){

            public void onCompleted(T result, Throwable t) {
                if (t != null) {
                    String serializedSourceQuery = SourceQueryRecordingInstrumentation.this.serializeSourceQuery(parameters.getExecutionInput());
                    if (serializedSourceQuery == null) {
                        return;
                    }
                    internalSession.recordSourceQuery(serializedSourceQuery, "GraphQL", t.getMessage());
                }
            }
        };
    }

    @Nullable
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState state) {
        ExecutionContext executionContext = parameters.getExecutionContext();
        final GraphQLContext graphQLContext = executionContext.getGraphQLContext();
        final EvitaInternalSessionContract internalSession = this.getInternalSession(graphQLContext);
        if (internalSession == null) {
            return SimpleInstrumentationContext.noOp();
        }
        String serializedSourceQuery = this.serializeSourceQuery(executionContext.getExecutionInput());
        if (serializedSourceQuery == null) {
            return SimpleInstrumentationContext.noOp();
        }
        final UUID recordingId = internalSession.recordSourceQuery(serializedSourceQuery, "GraphQL", null);
        graphQLContext.put((Object)GraphQLContextKey.TRAFFIC_SOURCE_QUERY_RECORDING_ID, (Object)recordingId);
        return new SimpleInstrumentationContext<ExecutionResult>(){

            public void onCompleted(ExecutionResult result, Throwable t) {
                List exceptionExceptions;
                StringBuilder combinedErrorMessage = new StringBuilder();
                if (t != null) {
                    combinedErrorMessage.append(t.getMessage());
                }
                if ((exceptionExceptions = (List)graphQLContext.get((Object)GraphQLContextKey.TRAFFIC_SOURCE_QUERY_RECORDING_EXCEPTIONS)) != null && !exceptionExceptions.isEmpty()) {
                    exceptionExceptions.forEach(exception -> combinedErrorMessage.append("; ").append(exception.getPublicMessage()));
                }
                internalSession.finalizeSourceQuery(recordingId, !combinedErrorMessage.isEmpty() ? combinedErrorMessage.toString() : null);
                graphQLContext.delete((Object)GraphQLContextKey.TRAFFIC_SOURCE_QUERY_RECORDING_ID);
            }
        };
    }

    @Nullable
    private EvitaInternalSessionContract getInternalSession(@Nonnull GraphQLContext graphQLContext) {
        if (!this.trafficRecordingOptions.sourceQueryTrackingEnabled()) {
            return null;
        }
        EvitaSessionContract evitaSession = (EvitaSessionContract)graphQLContext.get((Object)GraphQLContextKey.EVITA_SESSION);
        if (evitaSession == null) {
            return null;
        }
        if (!(evitaSession instanceof EvitaInternalSessionContract)) {
            log.error("Source query tracking is enabled but Evita session is not of internal type. Cannot record source query. Aborting.");
            return null;
        }
        EvitaInternalSessionContract evitaInternalSession = (EvitaInternalSessionContract)evitaSession;
        return evitaInternalSession;
    }

    @Nullable
    private String serializeSourceQuery(@Nonnull ExecutionInput executionInput) {
        SourceQueryDto sourceQuery = SourceQueryDto.from(executionInput);
        try {
            return this.objectMapper.writeValueAsString((Object)sourceQuery);
        }
        catch (JsonProcessingException e) {
            log.error("Cannot serialize source query for traffic recording. Aborting.", (Throwable)e);
            return null;
        }
    }

    @Generated
    public SourceQueryRecordingInstrumentation(@Nonnull ObjectMapper objectMapper, @Nonnull TrafficRecordingOptions trafficRecordingOptions) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (trafficRecordingOptions == null) {
            throw new NullPointerException("trafficRecordingOptions is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.trafficRecordingOptions = trafficRecordingOptions;
    }

    private record SourceQueryDto(@Nonnull String query, @Nonnull Map<String, Object> variables, @Nonnull Map<String, Object> extensions) {
        public static SourceQueryDto from(@Nonnull ExecutionInput executionInput) {
            return new SourceQueryDto(executionInput.getQuery(), executionInput.getVariables(), executionInput.getExtensions());
        }
    }
}

