/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import com.linecorp.armeria.common.HttpRequest;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import io.evitadb.externalApi.http.EndpointExecutionContext;
import io.evitadb.utils.Assert;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class GraphQLEndpointExecutionContext
extends EndpointExecutionContext {
    @Nonnull
    private final ExecutedEvent requestExecutedEvent;
    @Nullable
    private String requestBodyContentType;
    @Nullable
    private String preferredResponseContentType;

    public GraphQLEndpointExecutionContext(@Nonnull HttpRequest httpRequest, @Nonnull Evita evita, @Nonnull ExecutedEvent requestExecutedEvent) {
        super(httpRequest, evita);
        this.requestExecutedEvent = requestExecutedEvent;
    }

    @Nonnull
    public ExecutedEvent requestExecutedEvent() {
        return this.requestExecutedEvent;
    }

    public void provideRequestBodyContentType(@Nonnull String contentType) {
        Assert.isPremiseValid((this.requestBodyContentType == null ? 1 : 0) != 0, () -> new GraphQLInternalError("Request body content type already provided."));
        this.requestBodyContentType = contentType;
    }

    @Nullable
    public String requestBodyContentType() {
        return this.requestBodyContentType;
    }

    public void providePreferredResponseContentType(@Nonnull String contentType) {
        Assert.isPremiseValid((this.preferredResponseContentType == null ? 1 : 0) != 0, () -> new GraphQLInternalError("Preferred response content type already provided."));
        this.preferredResponseContentType = contentType;
    }

    @Nullable
    public String preferredResponseContentType() {
        return this.preferredResponseContentType;
    }

    public void notifyError(@Nonnull Exception e) {
        this.requestExecutedEvent.provideResponseStatus(ExecutedEvent.ResponseStatus.ERROR);
    }

    public void close() {
        this.requestExecutedEvent.finish().commit();
    }
}

