/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.tracing;

import graphql.ExecutionResult;
import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.language.OperationDefinition;
import io.evitadb.api.observability.trace.TracingBlockReference;
import io.evitadb.api.observability.trace.TracingContext;
import io.evitadb.api.observability.trace.TracingContextProvider;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.utils.GraphQLOperationNameResolver;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class OperationTracingInstrumentation
extends SimplePerformantInstrumentation {
    @Nonnull
    private final TracingContext tracingContext = TracingContextProvider.getContext();

    @Nonnull
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(@Nonnull InstrumentationExecuteOperationParameters parameters, @Nonnull InstrumentationState state) {
        ExecutionContext executionContext = parameters.getExecutionContext();
        OperationDefinition.Operation operation = executionContext.getOperationDefinition().getOperation();
        String operationName = GraphQLOperationNameResolver.resolve(executionContext.getOperationDefinition());
        TracingBlockReference blockReference = this.tracingContext.createAndActivateBlockIfParentContextAvailable("GraphQL " + operation.name().toLowerCase() + " - " + operationName, new TracingContext.SpanAttribute[]{new TracingContext.SpanAttribute("operation", (Object)operation.name()), new TracingContext.SpanAttribute("operationName", (Object)operationName)});
        if (blockReference != null) {
            executionContext.getGraphQLContext().put((Object)GraphQLContextKey.OPERATION_TRACING_BLOCK, (Object)blockReference);
        }
        return SimpleInstrumentationContext.noOp();
    }
}

