/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.resolver;

import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class SelectionSetAggregator {
    private static final String TYPENAME_FIELD = "__typename";
    private static final String FIELD_NAME_PATTERN_WILDCARD = "*";
    private static final List<SelectedField> EMPTY_LIST = List.of();
    @Nullable
    private final DataFetchingFieldSelectionSet originalSelectionSet;
    @Nullable
    private final List<DataFetchingFieldSelectionSet> originalSelectionSets;
    @Nullable
    private final String entityDtoObjectTypeName;

    public static SelectionSetAggregator from(@Nonnull DataFetchingFieldSelectionSet originalSelectionSet) {
        return new SelectionSetAggregator(originalSelectionSet, null, null);
    }

    public static SelectionSetAggregator from(@Nonnull List<DataFetchingFieldSelectionSet> originalSelectionSets) {
        return new SelectionSetAggregator(null, originalSelectionSets, null);
    }

    public static SelectionSetAggregator from(@Nonnull DataFetchingFieldSelectionSet originalSelectionSet, @Nonnull String entityDtoObjectTypeName) {
        return new SelectionSetAggregator(originalSelectionSet, null, entityDtoObjectTypeName);
    }

    public static SelectionSetAggregator from(@Nonnull List<DataFetchingFieldSelectionSet> originalSelectionSets, @Nonnull String entityDtoObjectTypeName) {
        return new SelectionSetAggregator(null, originalSelectionSets, entityDtoObjectTypeName);
    }

    public boolean containsImmediate(@Nonnull String fieldNamePattern) {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.containsImmediate(fieldNamePattern, this.originalSelectionSet, this.entityDtoObjectTypeName);
        }
        return SelectionSetAggregator.containsImmediate(fieldNamePattern, this.originalSelectionSets, this.entityDtoObjectTypeName);
    }

    @Nonnull
    public List<SelectedField> getImmediateFields() {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.getImmediateFields(this.originalSelectionSet, this.entityDtoObjectTypeName);
        }
        return SelectionSetAggregator.getImmediateFields(this.originalSelectionSets, this.entityDtoObjectTypeName);
    }

    @Nonnull
    public List<SelectedField> getImmediateFields(@Nonnull String fieldName) {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.getImmediateFields(fieldName, this.originalSelectionSet, this.entityDtoObjectTypeName);
        }
        return SelectionSetAggregator.getImmediateFields(fieldName, this.originalSelectionSets, this.entityDtoObjectTypeName);
    }

    @Nonnull
    public List<SelectedField> getImmediateFields(@Nonnull Set<String> fieldNames) {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.getImmediateFields(fieldNames, this.originalSelectionSet, this.entityDtoObjectTypeName);
        }
        return SelectionSetAggregator.getImmediateFields(fieldNames, this.originalSelectionSets, this.entityDtoObjectTypeName);
    }

    public boolean isEmpty() {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.isEmpty(this.originalSelectionSet, this.entityDtoObjectTypeName);
        }
        return SelectionSetAggregator.isEmpty(this.originalSelectionSets, this.entityDtoObjectTypeName);
    }

    public static boolean containsImmediate(@Nonnull String fieldNamePattern, @Nonnull DataFetchingFieldSelectionSet selectionSet) {
        return SelectionSetAggregator.containsImmediate(fieldNamePattern, selectionSet, null);
    }

    public static boolean containsImmediate(@Nonnull String fieldNamePattern, @Nonnull DataFetchingFieldSelectionSet selectionSet, @Nullable String entityDtoObjectTypeName) {
        List immediateFields = selectionSet.getImmediateFields();
        if (fieldNamePattern.endsWith(FIELD_NAME_PATTERN_WILDCARD)) {
            String normalizedPattern = fieldNamePattern.substring(0, fieldNamePattern.length() - 1);
            for (SelectedField field : immediateFields) {
                if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || !field.getName().startsWith(normalizedPattern)) continue;
                return true;
            }
        } else {
            for (SelectedField field : immediateFields) {
                if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || !field.getName().equals(fieldNamePattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsImmediate(@Nonnull String fieldNamePattern, @Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        return SelectionSetAggregator.containsImmediate(fieldNamePattern, selectionSets, null);
    }

    public static boolean containsImmediate(@Nonnull String fieldNamePattern, @Nonnull List<DataFetchingFieldSelectionSet> selectionSets, @Nullable String entityDtoObjectTypeName) {
        if (selectionSets.isEmpty()) {
            return false;
        }
        if (selectionSets.size() == 1) {
            return SelectionSetAggregator.containsImmediate(fieldNamePattern, selectionSets.get(0), entityDtoObjectTypeName);
        }
        if (fieldNamePattern.endsWith(FIELD_NAME_PATTERN_WILDCARD)) {
            String normalizedPattern = fieldNamePattern.substring(0, fieldNamePattern.length() - 1);
            for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
                for (SelectedField field : selectionSet.getImmediateFields()) {
                    if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || !field.getName().startsWith(normalizedPattern)) continue;
                    return true;
                }
            }
        } else {
            for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
                for (SelectedField field : selectionSet.getImmediateFields()) {
                    if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || !field.getName().equals(fieldNamePattern)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull DataFetchingFieldSelectionSet selectionSet) {
        return SelectionSetAggregator.getImmediateFields(selectionSet, null);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull DataFetchingFieldSelectionSet selectionSet, @Nullable String entityDtoObjectTypeName) {
        ArrayList<SelectedField> matchingFields = new ArrayList<SelectedField>(selectionSet.getImmediateFields().size());
        for (SelectedField field : selectionSet.getImmediateFields()) {
            if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || field.getName().equals(TYPENAME_FIELD)) continue;
            matchingFields.add(field);
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        return SelectionSetAggregator.getImmediateFields(selectionSets, null);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull List<DataFetchingFieldSelectionSet> selectionSets, @Nullable String entityDtoObjectTypeName) {
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
            for (SelectedField field : selectionSet.getImmediateFields()) {
                if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || field.getName().equals(TYPENAME_FIELD)) continue;
                matchingFields.add(field);
            }
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull String fieldName, @Nonnull DataFetchingFieldSelectionSet selectionSet) {
        return SelectionSetAggregator.getImmediateFields(fieldName, selectionSet, null);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull String fieldName, @Nonnull DataFetchingFieldSelectionSet selectionSet, @Nullable String entityDtoObjectTypeName) {
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (SelectedField field : selectionSet.getImmediateFields()) {
            if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || !field.getName().equals(fieldName)) continue;
            matchingFields.add(field);
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull Set<String> fieldNames, @Nonnull DataFetchingFieldSelectionSet selectionSet) {
        return SelectionSetAggregator.getImmediateFields(fieldNames, selectionSet, null);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull Set<String> fieldNames, @Nonnull DataFetchingFieldSelectionSet selectionSet, @Nullable String entityDtoObjectTypeName) {
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (SelectedField field : selectionSet.getImmediateFields()) {
            if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || !fieldNames.contains(field.getName())) continue;
            matchingFields.add(field);
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull String fieldName, @Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        return SelectionSetAggregator.getImmediateFields(fieldName, selectionSets, null);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull String fieldName, @Nonnull List<DataFetchingFieldSelectionSet> selectionSets, @Nullable String entityDtoObjectTypeName) {
        if (selectionSets.isEmpty()) {
            return EMPTY_LIST;
        }
        if (selectionSets.size() == 1) {
            return SelectionSetAggregator.getImmediateFields(fieldName, selectionSets.get(0), entityDtoObjectTypeName);
        }
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
            for (SelectedField field : selectionSet.getImmediateFields()) {
                if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || !field.getName().equals(fieldName)) continue;
                matchingFields.add(field);
            }
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull Set<String> fieldNames, @Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        return SelectionSetAggregator.getImmediateFields(fieldNames, selectionSets, null);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull Set<String> fieldNames, @Nonnull List<DataFetchingFieldSelectionSet> selectionSets, @Nullable String entityDtoObjectTypeName) {
        if (selectionSets.isEmpty()) {
            return EMPTY_LIST;
        }
        if (selectionSets.size() == 1) {
            return SelectionSetAggregator.getImmediateFields(fieldNames, selectionSets.get(0), entityDtoObjectTypeName);
        }
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
            for (SelectedField field : selectionSet.getImmediateFields()) {
                if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName) || !fieldNames.contains(field.getName())) continue;
                matchingFields.add(field);
            }
        }
        return Collections.unmodifiableList(matchingFields);
    }

    public static boolean isEmpty(@Nonnull DataFetchingFieldSelectionSet selectionSet) {
        return selectionSet.getImmediateFields().isEmpty();
    }

    public static boolean isEmpty(@Nonnull DataFetchingFieldSelectionSet selectionSet, @Nullable String entityDtoObjectTypeName) {
        for (SelectedField field : selectionSet.getImmediateFields()) {
            if (!SelectionSetAggregator.isFieldOfEntityDto(field, entityDtoObjectTypeName)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(@Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        if (selectionSets.isEmpty()) {
            return true;
        }
        if (selectionSets.size() == 1) {
            return SelectionSetAggregator.isEmpty(selectionSets.get(0));
        }
        for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
            if (SelectionSetAggregator.isEmpty(selectionSet)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(@Nonnull List<DataFetchingFieldSelectionSet> selectionSets, @Nullable String entityDtoObjectTypeName) {
        if (selectionSets.isEmpty()) {
            return true;
        }
        if (selectionSets.size() == 1) {
            return SelectionSetAggregator.isEmpty(selectionSets.get(0), entityDtoObjectTypeName);
        }
        for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
            if (SelectionSetAggregator.isEmpty(selectionSet, entityDtoObjectTypeName)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldOfEntityDto(@Nonnull SelectedField field, @Nullable String entityDtoObjectTypeName) {
        if (entityDtoObjectTypeName == null) {
            return true;
        }
        return field.getObjectTypeNames().contains(entityDtoObjectTypeName);
    }

    @Generated
    private SelectionSetAggregator(@Nullable DataFetchingFieldSelectionSet originalSelectionSet, @Nullable List<DataFetchingFieldSelectionSet> originalSelectionSets, @Nullable String entityDtoObjectTypeName) {
        this.originalSelectionSet = originalSelectionSet;
        this.originalSelectionSets = originalSelectionSets;
        this.entityDtoObjectTypeName = entityDtoObjectTypeName;
    }
}

