/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.IntValue;
import graphql.schema.CoercingParseLiteralException;
import io.evitadb.dataType.ShortNumberRange;
import io.evitadb.externalApi.graphql.api.dataType.coercing.RangeCoercing;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.math.BigInteger;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ShortNumberRangeCoercing
extends RangeCoercing<Short, ShortNumberRange, Integer> {
    @Override
    protected Class<ShortNumberRange> getRangeClass() {
        return ShortNumberRange.class;
    }

    @Override
    protected Class<Integer> getTupleComponentClass() {
        return Integer.class;
    }

    @Nonnull
    protected Integer[] createTuple(@Nullable Integer from, @Nullable Integer to) {
        return new Integer[]{from, to};
    }

    @Override
    @Nonnull
    protected ShortNumberRange createRange(@Nullable Short left, @Nullable Short right) {
        if (left != null && right != null) {
            return ShortNumberRange.between((Short)left, (Short)right);
        }
        if (left != null) {
            return ShortNumberRange.from((Short)left);
        }
        if (right != null) {
            return ShortNumberRange.to((Short)right);
        }
        throw new GraphQLInvalidArgumentException("Both left and right arguments cannot be null!");
    }

    @Override
    @Nonnull
    protected Integer extractRangeEndFromNode(@Nonnull Object node) {
        if (!(node instanceof IntValue)) {
            throw new CoercingParseLiteralException("Item of range input value is not a integer.");
        }
        return ((IntValue)node).getValue().intValueExact();
    }

    @Override
    @Nullable
    protected Integer formatRangeEnd(@Nullable Short end) {
        return Optional.ofNullable(end).map(e -> (int)e).orElse(null);
    }

    @Override
    @Nullable
    protected Short parseRangeEnd(@Nullable Integer end) {
        return Optional.ofNullable(end).map(e -> new BigInteger(end.toString()).shortValueExact()).orElse(null);
    }
}

