/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.CoercingParseLiteralException;
import io.evitadb.dataType.LongNumberRange;
import io.evitadb.externalApi.graphql.api.dataType.coercing.RangeCoercing;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LongNumberRangeCoercing
extends RangeCoercing<Long, LongNumberRange, String> {
    @Override
    protected Class<LongNumberRange> getRangeClass() {
        return LongNumberRange.class;
    }

    @Override
    protected Class<String> getTupleComponentClass() {
        return String.class;
    }

    @Nonnull
    protected String[] createTuple(@Nullable String from, @Nullable String to) {
        return new String[]{from, to};
    }

    @Override
    @Nonnull
    protected LongNumberRange createRange(@Nullable Long left, @Nullable Long right) {
        if (left != null && right != null) {
            return LongNumberRange.between((Long)left, (Long)right);
        }
        if (left != null) {
            return LongNumberRange.from((Long)left);
        }
        if (right != null) {
            return LongNumberRange.to((Long)right);
        }
        throw new GraphQLInvalidArgumentException("Both left and right arguments cannot be null!");
    }

    @Override
    @Nonnull
    protected String extractRangeEndFromNode(@Nonnull Object node) {
        if (!(node instanceof StringValue)) {
            throw new CoercingParseLiteralException("Item of range input value is not a string.");
        }
        return ((StringValue)node).getValue();
    }

    @Override
    @Nullable
    protected String formatRangeEnd(@Nullable Long end) {
        return Optional.ofNullable(end).map(Object::toString).orElse(null);
    }

    @Override
    @Nullable
    protected Long parseRangeEnd(@Nullable String end) {
        return Optional.ofNullable(end).map(Long::parseLong).orElse(null);
    }
}

