/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.data.PriceContract;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.dto.PrefetchedPriceForSale;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class AccompanyingPriceDataFetcher
implements DataFetcher<DataFetcherResult<PriceContract>> {
    @Nullable
    private static AccompanyingPriceDataFetcher INSTANCE;

    @Nonnull
    public static AccompanyingPriceDataFetcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AccompanyingPriceDataFetcher();
        }
        return INSTANCE;
    }

    @Nonnull
    public DataFetcherResult<PriceContract> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        PrefetchedPriceForSale prefetchedPrices = (PrefetchedPriceForSale)environment.getSource();
        String priceName = this.resolvePriceName(environment);
        Optional<PriceContract> priceForName = this.getPrefetchedPrice(prefetchedPrices, priceName);
        PriceContract pickedPrice = priceForName.orElse(null);
        return DataFetcherResult.newResult().data((Object)pickedPrice).build();
    }

    @Nonnull
    private String resolvePriceName(@Nonnull DataFetchingEnvironment environment) {
        return environment.getField().getAlias() != null ? environment.getField().getAlias() : environment.getField().getName();
    }

    @Nonnull
    private Optional<PriceContract> getPrefetchedPrice(@Nonnull PrefetchedPriceForSale prefetchedPrices, @Nonnull String priceName) {
        Optional<PriceContract> prefetchedPrice = prefetchedPrices.getAccompanyingPrices().get(priceName);
        if (prefetchedPrice == null) {
            throw new GraphQLInternalError("Missing prefetched price `" + priceName + "` for entity `" + prefetchedPrices.getParentEntity().getType() + ":" + prefetchedPrices.getParentEntity().getPrimaryKey() + "`.");
        }
        return prefetchedPrice;
    }

    @Generated
    private AccompanyingPriceDataFetcher() {
    }
}

