/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.ServiceRequestContext;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLException;
import graphql.execution.InputMapDefinesTooManyFieldsException;
import graphql.execution.NonNullableValueCoercedAsNullException;
import graphql.execution.UnknownOperationException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.evitadb.api.observability.trace.TracingBlockReference;
import io.evitadb.core.Evita;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.exception.EvitaInvalidUsageException;
import io.evitadb.externalApi.configuration.HeaderOptions;
import io.evitadb.externalApi.exception.ExternalApiInternalError;
import io.evitadb.externalApi.exception.ExternalApiInvalidUsageException;
import io.evitadb.externalApi.exception.HttpExchangeException;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidUsageException;
import io.evitadb.externalApi.graphql.io.GraphQLEndpointExecutionContext;
import io.evitadb.externalApi.graphql.io.GraphQLInstanceType;
import io.evitadb.externalApi.graphql.io.GraphQLRequest;
import io.evitadb.externalApi.graphql.io.GraphQLResponse;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import io.evitadb.externalApi.http.EndpointHandler;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.trace.ExternalApiTracingContextProvider;
import io.evitadb.externalApi.utils.ExternalApiTracingContext;
import io.evitadb.utils.CollectionUtils;
import io.netty.channel.EventLoop;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLHandler
extends EndpointHandler<GraphQLEndpointExecutionContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLHandler.class);
    private static final Set<Class<? extends GraphQLException>> GRAPHQL_USER_ERRORS = Set.of(CoercingSerializeException.class, CoercingParseValueException.class, NonNullableValueCoercedAsNullException.class, InputMapDefinesTooManyFieldsException.class, UnknownOperationException.class);
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final ExternalApiTracingContext<Object> tracingContext;
    @Nonnull
    private final GraphQLInstanceType instanceType;
    @Nonnull
    private final AtomicReference<GraphQL> graphQL;

    public GraphQLHandler(@Nonnull Evita evita, @Nonnull HeaderOptions headers, @Nonnull ObjectMapper objectMapper, @Nonnull GraphQLInstanceType instanceType, @Nonnull AtomicReference<GraphQL> graphQL) {
        this.evita = evita;
        this.objectMapper = objectMapper;
        this.tracingContext = ExternalApiTracingContextProvider.getContext((HeaderOptions)headers);
        this.instanceType = instanceType;
        this.graphQL = graphQL;
    }

    @Nonnull
    public HttpResponse serve(@Nonnull ServiceRequestContext ctx, @Nonnull HttpRequest req) {
        return this.instrumentRequest(ctx, req);
    }

    private HttpResponse instrumentRequest(@Nonnull ServiceRequestContext ctx, @Nonnull HttpRequest req) {
        return (HttpResponse)this.tracingContext.executeWithinBlock("GraphQL", (Object)req, () -> super.serve(ctx, req));
    }

    @Nonnull
    protected GraphQLEndpointExecutionContext createExecutionContext(@Nonnull HttpRequest httpRequest) {
        return new GraphQLEndpointExecutionContext(httpRequest, this.evita, new ExecutedEvent(this.instanceType));
    }

    @Nonnull
    protected CompletableFuture<EndpointResponse> doHandleRequest(@Nonnull GraphQLEndpointExecutionContext executionContext) {
        return this.parseRequestBody(executionContext, GraphQLRequest.class).thenApply(graphQLRequest -> {
            executionContext.requestExecutedEvent().finishInputDeserialization();
            GraphQLResponse graphQLResponse = (GraphQLResponse)this.tracingContext.executeWithinBlock("GraphQL", (Object)executionContext.httpRequest(), () -> this.executeRequest(executionContext, (GraphQLRequest)graphQLRequest));
            return new SuccessEndpointResponse((Object)graphQLResponse);
        });
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message) {
        return (T)((Object)new GraphQLInternalError(message));
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message, @Nonnull Throwable cause) {
        return (T)((Object)new GraphQLInternalError(message, cause));
    }

    @Nonnull
    protected <T extends ExternalApiInvalidUsageException> T createInvalidUsageException(@Nonnull String message) {
        return (T)((Object)new GraphQLInvalidUsageException(message));
    }

    @Nonnull
    public Set<HttpMethod> getSupportedHttpMethods() {
        return Set.of(HttpMethod.POST);
    }

    @Nonnull
    public Set<String> getSupportedRequestContentTypes() {
        return Set.of("application/json");
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        LinkedHashSet mediaTypes = CollectionUtils.createLinkedHashSet((int)2);
        mediaTypes.add("application/graphql-response+json");
        mediaTypes.add("application/json");
        return mediaTypes;
    }

    @Nonnull
    protected <T> CompletableFuture<T> parseRequestBody(@Nonnull GraphQLEndpointExecutionContext executionContext, @Nonnull Class<T> dataClass) {
        try {
            return this.readRawRequestBody(executionContext).thenApply(body -> {
                try {
                    return this.objectMapper.readValue(body, dataClass);
                }
                catch (IOException e) {
                    Throwable patt8038$temp = e.getCause();
                    if (patt8038$temp instanceof EvitaInternalError) {
                        EvitaInternalError internalError = (EvitaInternalError)patt8038$temp;
                        throw internalError;
                    }
                    Throwable patt8174$temp = e.getCause();
                    if (patt8174$temp instanceof EvitaInvalidUsageException) {
                        EvitaInvalidUsageException invalidUsageException = (EvitaInvalidUsageException)patt8174$temp;
                        throw invalidUsageException;
                    }
                    throw new HttpExchangeException(HttpStatus.UNSUPPORTED_MEDIA_TYPE.code(), "Invalid request body format. Expected JSON object.");
                }
            });
        }
        catch (EvitaInternalError | EvitaInvalidUsageException e) {
            throw new HttpExchangeException(HttpStatus.UNSUPPORTED_MEDIA_TYPE.code(), "Invalid request body format. Expected JSON object.");
        }
    }

    @Nonnull
    private GraphQLResponse<?> executeRequest(@Nonnull GraphQLEndpointExecutionContext executionContext, @Nonnull GraphQLRequest graphQLRequest) {
        try {
            ExecutionInput executionInput = graphQLRequest.toExecutionInput(executionContext);
            ExecutionResult result = (ExecutionResult)this.graphQL.get().executeAsync(executionInput).join();
            TracingBlockReference blockReference = (TracingBlockReference)executionInput.getGraphQLContext().get((Object)GraphQLContextKey.OPERATION_TRACING_BLOCK);
            if (blockReference != null) {
                blockReference.close();
            }
            return GraphQLResponse.fromExecutionResult(result);
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TimeoutException) {
                throw new HttpExchangeException(HttpStatus.GATEWAY_TIMEOUT.code(), "Could not complete GraphQL request. Process timed out.");
            }
            if (GRAPHQL_USER_ERRORS.contains(cause.getClass())) {
                throw new GraphQLInvalidUsageException("Invalid GraphQL API request: " + cause.getMessage());
            }
            if (cause instanceof GraphQLException) {
                GraphQLException graphQLException = (GraphQLException)cause;
                throw new GraphQLInternalError("Internal GraphQL API error: " + graphQLException.getMessage(), "Internal GraphQL API error.", (Throwable)graphQLException);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw new GraphQLInternalError("Internal GraphQL API error: " + e.getMessage(), "Internal GraphQL API error.", e);
        }
    }

    protected void writeResponse(@Nonnull GraphQLEndpointExecutionContext executionContext, @Nonnull HttpResponseWriter responseWriter, @Nonnull Object response, @Nonnull EventLoop eventExecutors) {
        try {
            responseWriter.write((Object)HttpData.copyOf((byte[])this.objectMapper.writeValueAsBytes(response)));
        }
        catch (IOException e) {
            throw new GraphQLInternalError("Could not serialize GraphQL API response to JSON: " + e.getMessage(), "Could not provide GraphQL API response.", e);
        }
        finally {
            executionContext.requestExecutedEvent().finishResultSerialization();
        }
    }
}

