/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.evitadb.dataType.EvitaDataTypes;
import io.evitadb.dataType.exception.InconvertibleDataTypeException;
import io.evitadb.dataType.exception.UnsupportedDataTypeException;
import java.io.Serializable;
import java.time.DateTimeException;
import java.util.Locale;
import javax.annotation.Nonnull;

public class LocaleCoercing
implements Coercing<Locale, String> {
    public String serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!(dataFetcherResult instanceof Locale)) {
            throw new CoercingSerializeException("Locale data fetcher result is not a Locale.");
        }
        try {
            return ((Locale)dataFetcherResult).toLanguageTag();
        }
        catch (DateTimeException ex) {
            throw new CoercingSerializeException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public Locale parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("Locale input is not a string.");
        }
        try {
            return (Locale)EvitaDataTypes.toTargetType((Serializable)((Object)((String)input)), Locale.class);
        }
        catch (InconvertibleDataTypeException | UnsupportedDataTypeException ex) {
            throw new CoercingParseValueException(ex.getMessage(), ex);
        }
    }

    @Nonnull
    public Locale parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseValueException("Locale input is not a StringValue.");
        }
        try {
            return (Locale)EvitaDataTypes.toTargetType((Serializable)((Object)((StringValue)input).getValue()), Locale.class);
        }
        catch (InconvertibleDataTypeException | UnsupportedDataTypeException ex) {
            throw new CoercingParseLiteralException(ex.getMessage(), ex);
        }
    }
}

