/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.util.Currency;
import javax.annotation.Nonnull;

public class CurrencyCoercing
implements Coercing<Currency, String> {
    public String serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!(dataFetcherResult instanceof Currency)) {
            throw new CoercingSerializeException("Currency data fetcher result is not a currency.");
        }
        return dataFetcherResult.toString();
    }

    @Nonnull
    public Currency parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("Currency input value is not a string.");
        }
        try {
            return Currency.getInstance((String)input);
        }
        catch (IllegalArgumentException ex) {
            throw new CoercingParseValueException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public Currency parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseValueException("Currency input value is not a string.");
        }
        try {
            return Currency.getInstance(((StringValue)input).getValue());
        }
        catch (IllegalArgumentException ex) {
            throw new CoercingParseLiteralException(ex.getMessage(), (Throwable)ex);
        }
    }
}

