/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.data.ReferenceContract;
import io.evitadb.api.requestResponse.data.structure.EntityDecorator;
import io.evitadb.api.requestResponse.schema.Cardinality;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.dataType.StripList;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import javax.annotation.Nonnull;
import lombok.Generated;

public class ReferenceStripDataFetcher
implements DataFetcher<StripList<ReferenceContract>> {
    @Nonnull
    private final ReferenceSchemaContract referenceSchema;

    @Nonnull
    public StripList<ReferenceContract> get(DataFetchingEnvironment environment) throws Exception {
        EntityDecorator entity = (EntityDecorator)environment.getSource();
        Assert.isPremiseValid((entity != null ? 1 : 0) != 0, (String)"Entity must not be null");
        Assert.isPremiseValid((this.referenceSchema.getCardinality() == Cardinality.ZERO_OR_MORE || this.referenceSchema.getCardinality() == Cardinality.ONE_OR_MORE ? 1 : 0) != 0, () -> new GraphQLQueryResolvingInternalError("Reference `" + this.referenceSchema.getName() + "` doesn't have cardinality of more references but more references were requested."));
        return (StripList)entity.getReferenceChunk(this.referenceSchema.getName());
    }

    @Generated
    public ReferenceStripDataFetcher(@Nonnull ReferenceSchemaContract referenceSchema) {
        if (referenceSchema == null) {
            throw new NullPointerException("referenceSchema is marked non-null but is null");
        }
        this.referenceSchema = referenceSchema;
    }
}

