/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.FilterConstraint;
import io.evitadb.api.query.HeadConstraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.head.Head;
import io.evitadb.api.query.require.PriceType;
import io.evitadb.api.query.require.QueryPriceMode;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.dataType.Scope;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.dto.QueryLabelDto;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.GetEntityHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.QueryLabelDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.ReadDataFetcher;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetEntityDataFetcher
implements DataFetcher<DataFetcherResult<EntityClassifier>>,
ReadDataFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetEntityDataFetcher.class);
    @Nonnull
    private final EntitySchemaContract entitySchema;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;

    public GetEntityDataFetcher(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
        this.entitySchema = entitySchema;
        FilterConstraintResolver filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        OrderConstraintResolver orderConstraintResolver = new OrderConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(filterConstraintResolver));
        RequireConstraintResolver requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(filterConstraintResolver));
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0), filterConstraintResolver, orderConstraintResolver, requireConstraintResolver);
    }

    @Nonnull
    public DataFetcherResult<EntityClassifier> get(DataFetchingEnvironment environment) {
        Arguments arguments = Arguments.from(environment, this.entitySchema);
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)environment.getGraphQlContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        Query query = requestExecutedEvent.measureInternalEvitaDBInputReconstruction(() -> {
            Head head = this.buildHead(environment, arguments);
            FilterBy filterBy = this.buildFilterBy(arguments);
            Require require = this.buildRequire(environment, arguments);
            return Query.query((HeadConstraint)head, (FilterBy)filterBy, (Require)require);
        });
        log.debug("Generated evitaDB query for single entity fetch of type `{}` is `{}`.", (Object)this.entitySchema.getName(), (Object)query);
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult();
        Optional entityClassifier = requestExecutedEvent.measureInternalEvitaDBExecution(() -> evitaSession.queryOne(query, EntityClassifier.class));
        entityClassifier.ifPresent(entity -> resultBuilder.data(entity).localContext((Object)GetEntityDataFetcher.buildResultContext(arguments)));
        return resultBuilder.build();
    }

    @Nullable
    private <LV extends Serializable & Comparable<LV>> Head buildHead(@Nonnull DataFetchingEnvironment environment, @Nonnull Arguments arguments) {
        LinkedList<Object> headConstraints = new LinkedList<Object>();
        headConstraints.add(QueryConstraints.collection((String)this.entitySchema.getName()));
        headConstraints.add(QueryConstraints.label((String)"source-type", (Comparable)((Object)"GraphQL")));
        headConstraints.add(QueryConstraints.label((String)"graphql-operation-name", (Comparable)((Object)environment.getOperationDefinition().getName())));
        GraphQLContext graphQlContext = environment.getGraphQlContext();
        UUID sourceRecordingId = (UUID)graphQlContext.get((Object)GraphQLContextKey.TRAFFIC_SOURCE_QUERY_RECORDING_ID);
        if (sourceRecordingId != null) {
            headConstraints.add(QueryConstraints.label((String)"source-query", (Comparable)sourceRecordingId));
        }
        if (arguments.labels() != null) {
            for (QueryLabelDto label : arguments.labels()) {
                headConstraints.add(QueryConstraints.label((String)label.name(), (Comparable)((Object)((Serializable)label.value()))));
            }
        }
        return QueryConstraints.head((HeadConstraint[])((HeadConstraint[])headConstraints.toArray(HeadConstraint[]::new)));
    }

    @Nonnull
    private <A extends Serializable & Comparable<A>> FilterBy buildFilterBy(@Nonnull Arguments arguments) {
        LinkedList<Object> filterConstraints = new LinkedList<Object>();
        if (arguments.primaryKey() != null) {
            filterConstraints.add(QueryConstraints.entityPrimaryKeyInSet((Integer[])new Integer[]{arguments.primaryKey()}));
        }
        filterConstraints.add(QueryConstraints.entityLocaleEquals((Locale)arguments.locale()));
        for (Map.Entry<AttributeSchemaContract, Object> attribute : arguments.uniqueAttributes().entrySet()) {
            filterConstraints.add(QueryConstraints.attributeEquals((String)attribute.getKey().getName(), (Serializable)((Serializable)attribute.getValue())));
        }
        if (arguments.priceInPriceLists() != null) {
            filterConstraints.add(QueryConstraints.priceInPriceLists((String[])arguments.priceInPriceLists()));
        }
        filterConstraints.add(QueryConstraints.priceInCurrency((Currency)arguments.priceInCurrency()));
        if (arguments.priceValidIn() != null) {
            filterConstraints.add(QueryConstraints.priceValidIn((OffsetDateTime)arguments.priceValidIn()));
        } else if (arguments.priceValidInNow()) {
            filterConstraints.add(QueryConstraints.priceValidInNow());
        }
        filterConstraints.add(QueryConstraints.scope((Scope[])arguments.scopes()));
        return QueryConstraints.filterBy((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)));
    }

    @Nonnull
    private Require buildRequire(@Nonnull DataFetchingEnvironment environment, @Nonnull Arguments arguments) {
        LinkedList<PriceType> requireConstraints = new LinkedList<PriceType>();
        this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(environment.getSelectionSet()), arguments.locale(), this.entitySchema).ifPresent(requireConstraints::add);
        requireConstraints.add(QueryConstraints.priceType((QueryPriceMode)arguments.priceType()));
        return QueryConstraints.require((RequireConstraint[])((RequireConstraint[])requireConstraints.toArray(RequireConstraint[]::new)));
    }

    @Nonnull
    private static EntityQueryContext buildResultContext(@Nonnull Arguments arguments) {
        return new EntityQueryContext(arguments.locale(), arguments.priceInCurrency(), arguments.priceInPriceLists(), arguments.priceValidIn(), arguments.priceValidInNow());
    }

    private record Arguments(@Nullable Integer primaryKey, @Nullable Locale locale, @Nullable Currency priceInCurrency, @Nullable String[] priceInPriceLists, @Nullable OffsetDateTime priceValidIn, boolean priceValidInNow, @Nonnull QueryPriceMode priceType, @Nonnull Scope[] scopes, @Nullable List<QueryLabelDto> labels, @Nonnull Map<AttributeSchemaContract, Object> uniqueAttributes) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment, @Nonnull EntitySchemaContract entitySchema) {
            HashMap<String, Object> arguments = new HashMap<String, Object>(environment.getArguments());
            Integer primaryKey = (Integer)arguments.remove(GetEntityHeaderDescriptor.PRIMARY_KEY.name());
            Locale locale = (Locale)arguments.remove(GetEntityHeaderDescriptor.LOCALE.name());
            Currency priceInCurrency = (Currency)arguments.remove(GetEntityHeaderDescriptor.PRICE_IN_CURRENCY.name());
            List priceInPriceLists = (List)arguments.remove(GetEntityHeaderDescriptor.PRICE_IN_PRICE_LISTS.name());
            OffsetDateTime priceValidIn = (OffsetDateTime)arguments.remove(GetEntityHeaderDescriptor.PRICE_VALID_IN.name());
            boolean priceValidInNow = Optional.ofNullable(arguments.remove(GetEntityHeaderDescriptor.PRICE_VALID_NOW.name())).orElse(false);
            QueryPriceMode priceType = Optional.ofNullable(arguments.remove(GetEntityHeaderDescriptor.PRICE_TYPE.name())).orElse(QueryPriceMode.WITH_TAX);
            Scope[] scopes = Optional.ofNullable((List)arguments.remove(GetEntityHeaderDescriptor.SCOPE.name())).map(it -> (Scope[])it.toArray(Scope[]::new)).orElse(Scope.DEFAULT_SCOPES);
            List labels = Optional.ofNullable((List)arguments.remove(GetEntityHeaderDescriptor.LABELS.name())).map(rawLabels -> rawLabels.stream().map(rawLabel -> new QueryLabelDto((String)rawLabel.get(QueryLabelDescriptor.NAME.name()), rawLabel.get(QueryLabelDescriptor.VALUE.name()))).toList()).orElse(null);
            Map<AttributeSchemaContract, Object> uniqueAttributes = Arguments.extractUniqueAttributesFromArguments(scopes, arguments, entitySchema);
            if (primaryKey == null && uniqueAttributes.isEmpty()) {
                throw new GraphQLInvalidArgumentException("Missing entity identifying argument (e.g. primary key or unique attribute).");
            }
            return new Arguments(primaryKey, locale, priceInCurrency, priceInPriceLists != null ? (String[])priceInPriceLists.toArray(String[]::new) : null, priceValidIn, priceValidInNow, priceType, scopes, labels, uniqueAttributes);
        }

        private static Map<AttributeSchemaContract, Object> extractUniqueAttributesFromArguments(@Nonnull Scope[] requestedScopes, @Nonnull HashMap<String, Object> remainingArguments, @Nonnull EntitySchemaContract entitySchema) {
            HashMap uniqueAttributes = CollectionUtils.createHashMap((int)remainingArguments.size());
            for (Map.Entry<String, Object> argument : remainingArguments.entrySet()) {
                String attributeName = argument.getKey();
                AttributeSchemaContract attributeSchema = entitySchema.getAttributeByName(attributeName, ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION).orElse(null);
                if (attributeSchema == null) continue;
                Assert.isPremiseValid((boolean)Arrays.stream(requestedScopes).anyMatch(arg_0 -> ((AttributeSchemaContract)attributeSchema).isUniqueInScope(arg_0)), () -> new GraphQLQueryResolvingInternalError("Cannot find entity by non-unique attribute `" + attributeName + "`."));
                Object attributeValue = argument.getValue();
                if (attributeValue == null) continue;
                uniqueAttributes.put(attributeSchema, attributeValue);
            }
            return uniqueAttributes;
        }
    }
}

