/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.system.model;

import io.evitadb.externalApi.api.model.EndpointDescriptor;
import io.evitadb.externalApi.api.model.ObjectDescriptor;
import io.evitadb.externalApi.api.model.ObjectPropertyDataTypeDescriptor;
import io.evitadb.externalApi.api.model.PrimitivePropertyDataTypeDescriptor;
import io.evitadb.externalApi.api.model.PropertyDataTypeDescriptor;
import io.evitadb.externalApi.api.system.model.CatalogDescriptor;
import io.evitadb.externalApi.api.system.model.CatalogUnionDescriptor;

public interface SystemRootDescriptor {
    public static final EndpointDescriptor LIVENESS = EndpointDescriptor.builder().operation("liveness").description("Returns `true` when the API is ready to take requests.\n").type((PropertyDataTypeDescriptor)PrimitivePropertyDataTypeDescriptor.nonNull(Boolean.class)).build();
    public static final EndpointDescriptor CATALOG = EndpointDescriptor.builder().operation("catalog").description("Returns single catalog by its name.\n").type((PropertyDataTypeDescriptor)ObjectPropertyDataTypeDescriptor.nullableRef((ObjectDescriptor)CatalogUnionDescriptor.THIS)).build();
    public static final EndpointDescriptor CATALOGS = EndpointDescriptor.builder().operation("catalogs").description("Returns all catalogs known to evitaDB.\n").type((PropertyDataTypeDescriptor)ObjectPropertyDataTypeDescriptor.nullableListRef((ObjectDescriptor)CatalogUnionDescriptor.THIS)).build();
    public static final EndpointDescriptor CREATE_CATALOG = EndpointDescriptor.builder().operation("createCatalog").description("Creates new catalog of particular name if it doesn't exist. New empty catalog is returned. The catalog\nis created in `WARMING_UP` state and must be switched to `ALIVE` state by calling `switchCatalogToAliveState`\nafter all bulk index operations are finished.\n").type((PropertyDataTypeDescriptor)ObjectPropertyDataTypeDescriptor.nonNullRef((ObjectDescriptor)CatalogDescriptor.THIS)).build();
    public static final EndpointDescriptor RENAME_CATALOG = EndpointDescriptor.builder().operation("renameCatalog").description("Renames existing catalog to a new name. The `newName` must not clash with any existing catalog name,\notherwise exception is thrown. If you need to rename catalog to a name of existing catalog use\nthe `replaceCatalog` mutation instead.\n\nIn case exception occurs the original catalog (`name`) is guaranteed to be untouched,\nand the `newName` will not be present.\n").type((PropertyDataTypeDescriptor)ObjectPropertyDataTypeDescriptor.nonNullRef((ObjectDescriptor)CatalogDescriptor.THIS)).build();
    public static final EndpointDescriptor SWITCH_CATALOG_TO_ALIVE_STATE = EndpointDescriptor.builder().operation("switchCatalogToAliveState").description("Switches catalog to the `ALIVE` state so that next request is operating in the new catalog state.\n\nCatalog's state is switched only when the state transition successfully occurs and this is signalized\nby return value.\n").type((PropertyDataTypeDescriptor)PrimitivePropertyDataTypeDescriptor.nonNull(Boolean.class)).build();
    public static final EndpointDescriptor REPLACE_CATALOG = EndpointDescriptor.builder().operation("replaceCatalog").description("Replaces existing catalog of particular with the contents of the another catalog. When this method is\nsuccessfully finished, the catalog `nameToBeReplacedWith` will be known under the name of the\n`nameToBeReplaced` and the original contents of the `nameToBeReplaced` will be purged entirely.\n\nIn case exception occurs, the original catalog (`nameToBeReplaced`) is guaranteed to be untouched, the\nstate of `nameToBeReplacedWith` is however unknown and should be treated as damaged.\n").type((PropertyDataTypeDescriptor)ObjectPropertyDataTypeDescriptor.nonNullRef((ObjectDescriptor)CatalogDescriptor.THIS)).build();
    public static final EndpointDescriptor DELETE_CATALOG_IF_EXISTS = EndpointDescriptor.builder().operation("deleteCatalogIfExists").description("Deletes catalog with name along with its contents on disk.\n").type((PropertyDataTypeDescriptor)PrimitivePropertyDataTypeDescriptor.nonNull(Boolean.class)).build();
}

