/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;

public class OffsetDateTimeCoercing
implements Coercing<OffsetDateTime, String> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final String EXPECTED_FORMAT = "yyyy-MM-ddTHH:mm:ss.sss+-HH:mm";

    public String serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!(dataFetcherResult instanceof OffsetDateTime)) {
            throw new CoercingSerializeException("Offset date time data fetcher result is not a offset date time.");
        }
        try {
            return ((OffsetDateTime)dataFetcherResult).truncatedTo(ChronoUnit.MILLIS).format(FORMATTER);
        }
        catch (DateTimeException ex) {
            throw new CoercingSerializeException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public OffsetDateTime parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("Offset date time input is not a string.");
        }
        try {
            return OffsetDateTime.parse((String)input, FORMATTER).truncatedTo(ChronoUnit.MILLIS);
        }
        catch (DateTimeParseException ex) {
            throw new CoercingParseValueException(this.getParseErrorMessage(ex), (Throwable)ex);
        }
    }

    @Nonnull
    public OffsetDateTime parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseValueException("Offset date time input is not a StringValue.");
        }
        try {
            return OffsetDateTime.parse(((StringValue)input).getValue(), FORMATTER).truncatedTo(ChronoUnit.MILLIS);
        }
        catch (DateTimeParseException ex) {
            throw new CoercingParseLiteralException(this.getParseErrorMessage(ex), (Throwable)ex);
        }
    }

    @Nonnull
    private String getParseErrorMessage(@Nonnull DateTimeParseException ex) {
        return String.format("%s. Expected date time in variation of format `%s`.", ex.getMessage(), EXPECTED_FORMAT);
    }
}

