/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.IntValue;
import graphql.schema.CoercingParseLiteralException;
import io.evitadb.dataType.IntegerNumberRange;
import io.evitadb.externalApi.graphql.api.dataType.coercing.RangeCoercing;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IntegerNumberRangeCoercing
extends RangeCoercing<Integer, IntegerNumberRange, Integer> {
    @Override
    protected Class<IntegerNumberRange> getRangeClass() {
        return IntegerNumberRange.class;
    }

    @Override
    protected Class<Integer> getTupleComponentClass() {
        return Integer.class;
    }

    @Nonnull
    protected Integer[] createTuple(@Nullable Integer from, @Nullable Integer to) {
        return new Integer[]{from, to};
    }

    @Override
    @Nonnull
    protected IntegerNumberRange createRange(@Nullable Integer left, @Nullable Integer right) {
        if (left != null && right != null) {
            return IntegerNumberRange.between((Integer)left, (Integer)right);
        }
        if (left != null) {
            return IntegerNumberRange.from((Integer)left);
        }
        if (right != null) {
            return IntegerNumberRange.to((Integer)right);
        }
        throw new GraphQLInvalidArgumentException("Both left and right arguments cannot be null!");
    }

    @Override
    @Nonnull
    protected Integer extractRangeEndFromNode(@Nonnull Object node) {
        if (!(node instanceof IntValue)) {
            throw new CoercingParseLiteralException("Item of range input value is not a integer.");
        }
        return ((IntValue)node).getValue().intValueExact();
    }

    @Override
    @Nullable
    protected Integer formatRangeEnd(@Nullable Integer end) {
        return end;
    }

    @Override
    @Nullable
    protected Integer parseRangeEnd(@Nullable Integer end) {
        return end;
    }
}

