/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.extraResult.Hierarchy;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.dto.LevelInfoDto;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.HierarchyRequireOutputNameResolver;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class SpecificHierarchyDataFetcher
implements DataFetcher<List<LevelInfoDto>> {
    @Nonnull
    public List<LevelInfoDto> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        String outputName;
        Map hierarchiesOfReference = (Map)environment.getSource();
        List hierarchy = (List)hierarchiesOfReference.get(outputName = HierarchyRequireOutputNameResolver.resolve(environment.getField()));
        Assert.isPremiseValid((hierarchy != null ? 1 : 0) != 0, () -> new GraphQLQueryResolvingInternalError("Missing hierarchy for name `" + outputName + "`"));
        LinkedList<LevelInfoDto> flattenedHierarchy = new LinkedList<LevelInfoDto>();
        hierarchy.forEach(rootLevelInfo -> this.createLevelInfoDto((List<LevelInfoDto>)flattenedHierarchy, (Hierarchy.LevelInfo)rootLevelInfo, 1));
        return flattenedHierarchy;
    }

    private void createLevelInfoDto(@Nonnull List<LevelInfoDto> flattenedHierarchy, @Nonnull Hierarchy.LevelInfo levelInfo, int currentLevel) {
        LevelInfoDto currentLevelInfoDto = new LevelInfoDto(currentLevel, levelInfo.entity(), levelInfo.requested(), levelInfo.queriedEntityCount(), levelInfo.childrenCount());
        flattenedHierarchy.add(currentLevelInfoDto);
        levelInfo.children().forEach(childLevelInfo -> this.createLevelInfoDto(flattenedHierarchy, (Hierarchy.LevelInfo)childLevelInfo, currentLevel + 1));
    }
}

