/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.EvitaResponse;
import io.evitadb.api.requestResponse.extraResult.Hierarchy;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HierarchyDescriptor;
import io.evitadb.utils.CollectionUtils;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HierarchyDataFetcher
implements DataFetcher<Map<String, Map<String, List<Hierarchy.LevelInfo>>>> {
    @Nonnull
    private final Map<String, String> referenceNameToFieldName;

    public HierarchyDataFetcher(@Nonnull Collection<ReferenceSchemaContract> referenceSchemas) {
        this.referenceNameToFieldName = referenceSchemas.stream().map(referenceSchema -> new AbstractMap.SimpleEntry<String, String>(referenceSchema.getName(), referenceSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nullable
    public Map<String, Map<String, List<Hierarchy.LevelInfo>>> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        EvitaResponse response = (EvitaResponse)environment.getSource();
        Hierarchy hierarchy = (Hierarchy)response.getExtraResult(Hierarchy.class);
        if (hierarchy == null) {
            return null;
        }
        HashMap hierarchyDto = CollectionUtils.createHashMap((int)(hierarchy.getReferenceHierarchies().size() + 1));
        hierarchyDto.put(HierarchyDescriptor.SELF.name(), hierarchy.getSelfHierarchy());
        hierarchy.getReferenceHierarchies().forEach((key, value) -> hierarchyDto.put(this.referenceNameToFieldName.get(key), value));
        return hierarchyDto;
    }
}

