/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.evitadb.externalApi.configuration.AbstractApiConfiguration;
import io.evitadb.externalApi.configuration.ApiWithSpecificPrefix;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GraphQLConfig
extends AbstractApiConfiguration
implements ApiWithSpecificPrefix {
    private static final String BASE_GRAPHQL_PATH = "gql";
    private final String prefix;
    private final boolean parallelize;

    public GraphQLConfig() {
        this.prefix = BASE_GRAPHQL_PATH;
        this.parallelize = true;
    }

    public GraphQLConfig(@Nonnull String host) {
        super(Boolean.valueOf(true), host);
        this.prefix = BASE_GRAPHQL_PATH;
        this.parallelize = true;
    }

    @JsonCreator
    public GraphQLConfig(@Nullable @JsonProperty(value="enabled") Boolean enabled, @Nonnull @JsonProperty(value="host") String host, @Nullable @JsonProperty(value="exposeOn") String exposeOn, @Nullable @JsonProperty(value="tlsMode") String tlsMode, @Nullable @JsonProperty(value="keepAlive") Boolean keepAlive, @Nullable @JsonProperty(value="prefix") String prefix, @Nullable @JsonProperty(value="parallelize") Boolean parallelize) {
        super(enabled, host, exposeOn, tlsMode, keepAlive);
        this.prefix = Optional.ofNullable(prefix).orElse(BASE_GRAPHQL_PATH);
        this.parallelize = Optional.ofNullable(parallelize).orElse(false);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isParallelize() {
        return this.parallelize;
    }
}

