/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.system.builder;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import io.evitadb.api.CatalogContract;
import io.evitadb.core.Catalog;
import io.evitadb.core.CorruptedCatalog;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.api.catalog.schemaApi.model.NameVariantsDescriptor;
import io.evitadb.externalApi.api.model.EndpointDescriptorTransformer;
import io.evitadb.externalApi.api.model.ObjectDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.api.system.model.CatalogDescriptor;
import io.evitadb.externalApi.api.system.model.CatalogUnionDescriptor;
import io.evitadb.externalApi.api.system.model.CorruptedCatalogDescriptor;
import io.evitadb.externalApi.graphql.api.builder.BuiltFieldDescriptor;
import io.evitadb.externalApi.graphql.api.builder.FinalGraphQLSchemaBuilder;
import io.evitadb.externalApi.graphql.api.builder.GraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.catalog.schemaApi.resolver.dataFetcher.NameVariantDataFetcher;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.AsyncDataFetcher;
import io.evitadb.externalApi.graphql.api.system.model.CatalogQueryHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.system.model.CreateCatalogMutationHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.system.model.DeleteCatalogIfExistsMutationHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.system.model.RenameCatalogMutationHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.system.model.ReplaceCatalogMutationHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.system.model.SwitchCatalogToAliveStateMutationHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.system.model.SystemRootDescriptor;
import io.evitadb.externalApi.graphql.api.system.resolver.dataFetcher.CatalogDataFetcher;
import io.evitadb.externalApi.graphql.api.system.resolver.dataFetcher.CatalogsDataFetcher;
import io.evitadb.externalApi.graphql.api.system.resolver.dataFetcher.LivenessDataFetcher;
import io.evitadb.externalApi.graphql.api.system.resolver.mutatingDataFetcher.CreateCatalogMutatingDataFetcher;
import io.evitadb.externalApi.graphql.api.system.resolver.mutatingDataFetcher.DeleteCatalogIfExistsMutatingDataFetcher;
import io.evitadb.externalApi.graphql.api.system.resolver.mutatingDataFetcher.RenameCatalogMutatingDataFetcher;
import io.evitadb.externalApi.graphql.api.system.resolver.mutatingDataFetcher.ReplaceCatalogMutatingDataFetcher;
import io.evitadb.externalApi.graphql.api.system.resolver.mutatingDataFetcher.SwitchCatalogToAliveStateMutatingDataFetcher;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.utils.NamingConvention;
import java.util.Map;
import javax.annotation.Nonnull;

public class SystemGraphQLSchemaBuilder
extends FinalGraphQLSchemaBuilder<GraphQLSchemaBuildingContext> {
    private static final NameVariantDataFetcher CAMEL_CASE_VARIANT_DATA_FETCHER = new NameVariantDataFetcher(NamingConvention.CAMEL_CASE);
    private static final NameVariantDataFetcher PASCAL_CASE_VARIANT_DATA_FETCHER = new NameVariantDataFetcher(NamingConvention.PASCAL_CASE);
    private static final NameVariantDataFetcher SNAKE_CASE_VARIANT_DATA_FETCHER = new NameVariantDataFetcher(NamingConvention.SNAKE_CASE);
    private static final NameVariantDataFetcher UPPER_SNAKE_CASE_VARIANT_DATA_FETCHER = new NameVariantDataFetcher(NamingConvention.UPPER_SNAKE_CASE);
    private static final NameVariantDataFetcher KEBAB_CASE_VARIANT_DATA_FETCHER = new NameVariantDataFetcher(NamingConvention.KEBAB_CASE);
    private static final PropertyDataFetcher<Map<NamingConvention, String>> CATALOG_NAME_VARIANTS_DATA_FETCHER = PropertyDataFetcher.fetching(it -> ((Catalog)it).getSchema().getNameVariants());
    private static final PropertyDataFetcher<Boolean> CATALOG_SUPPORTS_TRANSACTION_DATA_FETCHER = PropertyDataFetcher.fetching(CatalogContract::supportsTransaction);
    private static final PropertyDataFetcher<Boolean> CATALOG_CORRUPTED_DATA_FETCHER = PropertyDataFetcher.fetching(it -> false);
    private static final PropertyDataFetcher<String> CORRUPTED_CATALOG_STORAGE_PATH_DATA_FETCHER = PropertyDataFetcher.fetching(it -> ((CorruptedCatalog)it).getCatalogStoragePath().toString());
    private static final PropertyDataFetcher<String> CORRUPTED_CATALOG_CAUSE_DATA_FETCHER = PropertyDataFetcher.fetching(it -> ((CorruptedCatalog)it).getCause().toString());
    private static final PropertyDataFetcher<Boolean> CORRUPTED_CATALOG_CORRUPTED_DATA_FETCHER = PropertyDataFetcher.fetching(it -> true);
    @Nonnull
    private final Evita evita;

    public SystemGraphQLSchemaBuilder(@Nonnull GraphQLConfig config, @Nonnull Evita evita) {
        super(new GraphQLSchemaBuildingContext(config, evita));
        this.evita = evita;
    }

    @Override
    @Nonnull
    public GraphQLSchema build() {
        this.buildingContext.registerType((GraphQLType)this.buildNameVariantsObject());
        GraphQLObjectType catalogObject = this.buildCatalogObject();
        this.buildingContext.registerType((GraphQLType)catalogObject);
        GraphQLObjectType corruptedCatalogObject = this.buildCorruptedCatalogObject();
        this.buildingContext.registerType((GraphQLType)corruptedCatalogObject);
        this.buildingContext.registerType((GraphQLType)this.buildCatalogUnion(catalogObject, corruptedCatalogObject));
        this.buildingContext.registerQueryField(this.buildLivenessField());
        this.buildingContext.registerQueryField(this.buildCatalogField());
        this.buildingContext.registerQueryField(this.buildCatalogsField());
        this.buildingContext.registerMutationField(this.buildCreateCatalogField());
        this.buildingContext.registerMutationField(this.buildSwitchCatalogToAliveStateField());
        this.buildingContext.registerMutationField(this.buildRenameCatalogField());
        this.buildingContext.registerMutationField(this.buildReplaceCatalogField());
        this.buildingContext.registerMutationField(this.buildDeleteCatalogIfExistsField());
        return this.buildingContext.buildGraphQLSchema();
    }

    @Nonnull
    private GraphQLObjectType buildNameVariantsObject() {
        this.buildingContext.registerDataFetcher(NameVariantsDescriptor.THIS, NameVariantsDescriptor.CAMEL_CASE, CAMEL_CASE_VARIANT_DATA_FETCHER);
        this.buildingContext.registerDataFetcher(NameVariantsDescriptor.THIS, NameVariantsDescriptor.PASCAL_CASE, PASCAL_CASE_VARIANT_DATA_FETCHER);
        this.buildingContext.registerDataFetcher(NameVariantsDescriptor.THIS, NameVariantsDescriptor.SNAKE_CASE, SNAKE_CASE_VARIANT_DATA_FETCHER);
        this.buildingContext.registerDataFetcher(NameVariantsDescriptor.THIS, NameVariantsDescriptor.UPPER_SNAKE_CASE, UPPER_SNAKE_CASE_VARIANT_DATA_FETCHER);
        this.buildingContext.registerDataFetcher(NameVariantsDescriptor.THIS, NameVariantsDescriptor.KEBAB_CASE, KEBAB_CASE_VARIANT_DATA_FETCHER);
        return ((GraphQLObjectType.Builder)NameVariantsDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build();
    }

    @Nonnull
    private GraphQLObjectType buildCatalogObject() {
        this.buildingContext.registerDataFetcher(CatalogDescriptor.THIS, CatalogDescriptor.NAME_VARIANTS, (DataFetcher<?>)CATALOG_NAME_VARIANTS_DATA_FETCHER);
        this.buildingContext.registerDataFetcher(CatalogDescriptor.THIS, CatalogDescriptor.SUPPORTS_TRANSACTION, (DataFetcher<?>)CATALOG_SUPPORTS_TRANSACTION_DATA_FETCHER);
        this.buildingContext.registerDataFetcher(CatalogDescriptor.THIS, CatalogDescriptor.CORRUPTED, (DataFetcher<?>)CATALOG_CORRUPTED_DATA_FETCHER);
        return ((GraphQLObjectType.Builder)CatalogDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build();
    }

    @Nonnull
    private GraphQLObjectType buildCorruptedCatalogObject() {
        this.buildingContext.registerDataFetcher(CorruptedCatalogDescriptor.THIS, CorruptedCatalogDescriptor.CATALOG_STORAGE_PATH, (DataFetcher<?>)CORRUPTED_CATALOG_STORAGE_PATH_DATA_FETCHER);
        this.buildingContext.registerDataFetcher(CorruptedCatalogDescriptor.THIS, CorruptedCatalogDescriptor.CAUSE, (DataFetcher<?>)CORRUPTED_CATALOG_CAUSE_DATA_FETCHER);
        this.buildingContext.registerDataFetcher(CorruptedCatalogDescriptor.THIS, CorruptedCatalogDescriptor.CORRUPTED, (DataFetcher<?>)CORRUPTED_CATALOG_CORRUPTED_DATA_FETCHER);
        return ((GraphQLObjectType.Builder)CorruptedCatalogDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build();
    }

    @Nonnull
    private GraphQLUnionType buildCatalogUnion(@Nonnull GraphQLObjectType catalogObject, @Nonnull GraphQLObjectType corruptedCatalogObject) {
        GraphQLUnionType catalogUnion = ((GraphQLUnionType.Builder)CatalogUnionDescriptor.THIS.to((ObjectDescriptorTransformer)this.unionBuilderTransformer)).possibleTypes(new GraphQLObjectType[]{catalogObject}).possibleType(corruptedCatalogObject).build();
        TypeResolver catalogUnionResolver = env -> {
            if (env.getObject() instanceof CorruptedCatalog) {
                return corruptedCatalogObject;
            }
            return catalogObject;
        };
        this.buildingContext.registerTypeResolver(catalogUnion, catalogUnionResolver);
        return catalogUnion;
    }

    @Nonnull
    private BuiltFieldDescriptor buildLivenessField() {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)SystemRootDescriptor.LIVENESS.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).build(), new AsyncDataFetcher(LivenessDataFetcher.getInstance(), this.buildingContext.getConfig(), this.buildingContext.getTracingContext(), this.buildingContext.getEvita()));
    }

    @Nonnull
    private BuiltFieldDescriptor buildCatalogField() {
        GraphQLFieldDefinition catalogField = ((GraphQLFieldDefinition.Builder)SystemRootDescriptor.CATALOG.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).argument((GraphQLArgument.Builder)CatalogQueryHeaderDescriptor.NAME.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build();
        return new BuiltFieldDescriptor(catalogField, new AsyncDataFetcher(new CatalogDataFetcher(this.evita), this.buildingContext.getConfig(), this.buildingContext.getTracingContext(), this.buildingContext.getEvita()));
    }

    @Nonnull
    private BuiltFieldDescriptor buildCatalogsField() {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)SystemRootDescriptor.CATALOGS.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).build(), new AsyncDataFetcher(new CatalogsDataFetcher(this.evita), this.buildingContext.getConfig(), this.buildingContext.getTracingContext(), this.buildingContext.getEvita()));
    }

    @Nonnull
    private BuiltFieldDescriptor buildCreateCatalogField() {
        GraphQLFieldDefinition createCatalogField = ((GraphQLFieldDefinition.Builder)SystemRootDescriptor.CREATE_CATALOG.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).argument((GraphQLArgument.Builder)CreateCatalogMutationHeaderDescriptor.NAME.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build();
        return new BuiltFieldDescriptor(createCatalogField, new AsyncDataFetcher(new CreateCatalogMutatingDataFetcher(this.evita), this.buildingContext.getConfig(), this.buildingContext.getTracingContext(), this.buildingContext.getEvita()));
    }

    @Nonnull
    private BuiltFieldDescriptor buildSwitchCatalogToAliveStateField() {
        GraphQLFieldDefinition switchCatalogToAliveStateField = ((GraphQLFieldDefinition.Builder)SystemRootDescriptor.SWITCH_CATALOG_TO_ALIVE_STATE.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).argument((GraphQLArgument.Builder)SwitchCatalogToAliveStateMutationHeaderDescriptor.NAME.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build();
        return new BuiltFieldDescriptor(switchCatalogToAliveStateField, new AsyncDataFetcher(new SwitchCatalogToAliveStateMutatingDataFetcher(this.evita), this.buildingContext.getConfig(), this.buildingContext.getTracingContext(), this.buildingContext.getEvita()));
    }

    @Nonnull
    private BuiltFieldDescriptor buildRenameCatalogField() {
        GraphQLFieldDefinition renameCatalogField = ((GraphQLFieldDefinition.Builder)SystemRootDescriptor.RENAME_CATALOG.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).argument((GraphQLArgument.Builder)RenameCatalogMutationHeaderDescriptor.NAME.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument((GraphQLArgument.Builder)RenameCatalogMutationHeaderDescriptor.NEW_NAME.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build();
        return new BuiltFieldDescriptor(renameCatalogField, new AsyncDataFetcher(new RenameCatalogMutatingDataFetcher(this.evita), this.buildingContext.getConfig(), this.buildingContext.getTracingContext(), this.buildingContext.getEvita()));
    }

    @Nonnull
    private BuiltFieldDescriptor buildReplaceCatalogField() {
        GraphQLFieldDefinition replaceCatalogField = ((GraphQLFieldDefinition.Builder)SystemRootDescriptor.REPLACE_CATALOG.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).argument((GraphQLArgument.Builder)ReplaceCatalogMutationHeaderDescriptor.NAME_TO_BE_REPLACED.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument((GraphQLArgument.Builder)ReplaceCatalogMutationHeaderDescriptor.NAME_TO_BE_REPLACED_WITH.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build();
        return new BuiltFieldDescriptor(replaceCatalogField, new AsyncDataFetcher(new ReplaceCatalogMutatingDataFetcher(this.evita), this.buildingContext.getConfig(), this.buildingContext.getTracingContext(), this.buildingContext.getEvita()));
    }

    @Nonnull
    private BuiltFieldDescriptor buildDeleteCatalogIfExistsField() {
        GraphQLFieldDefinition deleteCatalogIfExistsCatalogField = ((GraphQLFieldDefinition.Builder)SystemRootDescriptor.DELETE_CATALOG_IF_EXISTS.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).argument((GraphQLArgument.Builder)DeleteCatalogIfExistsMutationHeaderDescriptor.NAME.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build();
        return new BuiltFieldDescriptor(deleteCatalogIfExistsCatalogField, new AsyncDataFetcher(new DeleteCatalogIfExistsMutatingDataFetcher(this.evita), this.buildingContext.getConfig(), this.buildingContext.getTracingContext(), this.buildingContext.getEvita()));
    }
}

