/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.resolver.dataFetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.observability.trace.TracingContext;
import io.evitadb.api.observability.trace.TracingContextReference;
import io.evitadb.core.Evita;
import io.evitadb.core.async.ObservableExecutorService;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.ReadDataFetcher;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.WriteDataFetcher;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDataFetcher
implements DataFetcher<Object> {
    private static final Logger log = LoggerFactory.getLogger(AsyncDataFetcher.class);
    private final boolean enabled;
    @Nonnull
    private final DataFetcher<?> delegate;
    @Nonnull
    private final ObservableExecutorService executorService;
    @Nonnull
    private final TracingContext tracingContext;
    @Nonnull
    private final String tracingBlockDescription;

    public AsyncDataFetcher(@Nonnull DataFetcher<?> delegate, @Nonnull GraphQLConfig config, @Nonnull TracingContext tracingContext, @Nullable Evita evita) {
        this.enabled = config.isParallelize();
        this.delegate = delegate;
        this.executorService = this.resolveExecutor(evita);
        this.tracingContext = tracingContext;
        this.tracingBlockDescription = this.resolveTracingBlockDescription();
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        if (!this.enabled) {
            log.debug("No executor for processing data fetcher `" + this.getClass().getName() + "`, processing synchronously.");
            return this.delegate.get(environment);
        }
        TracingContextReference parentContextReference = this.tracingContext.getCurrentContext();
        return CompletableFuture.supplyAsync(() -> this.tracingContext.executeWithinBlockWithParentContext(parentContextReference, this.tracingBlockDescription, () -> {
            try {
                return this.delegate.get(environment);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)e;
                    throw re;
                }
                throw new GraphQLInternalError("Unexpected exception occurred during data fetching.", e);
            }
        }), (Executor)this.executorService);
    }

    @Nonnull
    private String resolveTracingBlockDescription() {
        if (ReadDataFetcher.class.isAssignableFrom(this.delegate.getClass())) {
            return "GraphQL query fetch";
        }
        if (WriteDataFetcher.class.isAssignableFrom(this.delegate.getClass())) {
            return "GraphQL mutation write";
        }
        throw new GraphQLInternalError("Unsupported GraphQL root fetcher type on `" + String.valueOf(this.delegate.getClass()) + "`.");
    }

    @Nonnull
    private ObservableExecutorService resolveExecutor(@Nonnull Evita evita) {
        if (ReadDataFetcher.class.isAssignableFrom(this.delegate.getClass())) {
            return evita.getRequestExecutor();
        }
        if (WriteDataFetcher.class.isAssignableFrom(this.delegate.getClass())) {
            return evita.getTransactionExecutor();
        }
        throw new GraphQLInternalError("Unsupported GraphQL async fetcher type on `" + String.valueOf(this.delegate.getClass()) + "`.");
    }
}

