/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.IntValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigInteger;
import javax.annotation.Nonnull;

public class ShortCoercing
implements Coercing<Short, Integer> {
    @Nonnull
    public Integer serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!(dataFetcherResult instanceof Short)) {
            throw new CoercingSerializeException("Short data fetcher result is not a short.");
        }
        return (int)((Integer)dataFetcherResult);
    }

    @Nonnull
    public Short parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof Integer)) {
            throw new CoercingParseValueException("Short input value is not a integer.");
        }
        try {
            return new BigInteger(input.toString()).shortValueExact();
        }
        catch (ArithmeticException | NumberFormatException ex) {
            throw new CoercingParseValueException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public Short parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof IntValue)) {
            throw new CoercingParseValueException("Short input value is not a integer.");
        }
        try {
            return ((IntValue)input).getValue().shortValueExact();
        }
        catch (ArithmeticException | NumberFormatException ex) {
            throw new CoercingParseLiteralException(ex.getMessage(), (Throwable)ex);
        }
    }
}

