/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.query.require.QueryPriceMode;
import io.evitadb.api.requestResponse.data.PriceInnerRecordHandling;
import io.evitadb.api.requestResponse.data.structure.EntityDecorator;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.MultiplePricesForSaleAvailableFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultiplePricesForSaleAvailableDataFetcher
implements DataFetcher<Boolean> {
    @Nullable
    private static MultiplePricesForSaleAvailableDataFetcher INSTANCE;

    @Nonnull
    public static MultiplePricesForSaleAvailableDataFetcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MultiplePricesForSaleAvailableDataFetcher();
        }
        return INSTANCE;
    }

    @Nonnull
    public Boolean get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        boolean hasMultiplePricesForSale;
        OffsetDateTime validIn;
        EntityDecorator entity = (EntityDecorator)environment.getSource();
        EntityQueryContext context = (EntityQueryContext)environment.getLocalContext();
        String[] priceLists = this.resolveDesiredPricesLists(environment, context);
        Currency currency = this.resolveDesiredCurrency(environment, context);
        List allPricesForSale = entity.getAllPricesForSale(currency, validIn = this.resolveDesiredValidIn(environment, entity, context), priceLists);
        if (allPricesForSale.size() <= 1) {
            return false;
        }
        PriceInnerRecordHandling priceInnerRecordHandling = entity.getPriceInnerRecordHandling();
        if (priceInnerRecordHandling.equals((Object)PriceInnerRecordHandling.LOWEST_PRICE)) {
            if (allPricesForSale.size() <= 1) {
                return false;
            }
            QueryPriceMode desiredPriceType = entity.getPricePredicate().getQueryPriceMode();
            long uniquePriceValuesCount = allPricesForSale.stream().map(price -> {
                if (desiredPriceType.equals((Object)QueryPriceMode.WITH_TAX)) {
                    return price.priceWithTax();
                }
                if (desiredPriceType.equals((Object)QueryPriceMode.WITHOUT_TAX)) {
                    return price.priceWithoutTax();
                }
                throw new GraphQLInternalError("Unsupported price type `" + String.valueOf(desiredPriceType) + "`");
            }).distinct().count();
            hasMultiplePricesForSale = uniquePriceValuesCount > 1L;
        } else {
            hasMultiplePricesForSale = false;
        }
        return hasMultiplePricesForSale;
    }

    @Nonnull
    protected String[] resolveDesiredPricesLists(@Nonnull DataFetchingEnvironment environment, @Nonnull EntityQueryContext context) {
        return Optional.ofNullable((List)environment.getArgument(MultiplePricesForSaleAvailableFieldHeaderDescriptor.PRICE_LISTS.name())).map(it -> (String[])it.toArray(String[]::new)).or(() -> Optional.ofNullable(context.getDesiredPriceInPriceLists())).orElseThrow(() -> new GraphQLInvalidArgumentException("Missing price list argument. You can use `" + MultiplePricesForSaleAvailableFieldHeaderDescriptor.PRICE_LISTS.name() + "` parameter for specifying custom price list."));
    }

    @Nonnull
    protected Currency resolveDesiredCurrency(@Nonnull DataFetchingEnvironment environment, @Nonnull EntityQueryContext context) {
        return Optional.ofNullable((Currency)environment.getArgument(MultiplePricesForSaleAvailableFieldHeaderDescriptor.CURRENCY.name())).or(() -> Optional.ofNullable(context.getDesiredPriceInCurrency())).orElseThrow(() -> new GraphQLInvalidArgumentException("Missing `currency` argument. You can use `" + MultiplePricesForSaleAvailableFieldHeaderDescriptor.CURRENCY.name() + "` parameter for specifying custom currency."));
    }

    @Nullable
    protected OffsetDateTime resolveDesiredValidIn(@Nonnull DataFetchingEnvironment environment, @Nonnull EntityDecorator entity, @Nonnull EntityQueryContext context) {
        return Optional.ofNullable((OffsetDateTime)environment.getArgument(MultiplePricesForSaleAvailableFieldHeaderDescriptor.VALID_IN.name())).or(() -> Optional.ofNullable((Boolean)environment.getArgument(MultiplePricesForSaleAvailableFieldHeaderDescriptor.VALID_NOW.name())).map(validNow -> validNow != false ? entity.getAlignedNow() : null)).or(() -> Optional.ofNullable(context.getDesiredPriceValidIn())).or(() -> Optional.of(context.isDesiredPriceValidInNow()).map(validNow -> validNow != false ? entity.getAlignedNow() : null)).orElse(null);
    }

    private MultiplePricesForSaleAvailableDataFetcher() {
    }
}

