/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import io.evitadb.api.requestResponse.data.PriceContract;
import io.evitadb.api.requestResponse.data.PricesContract;
import io.evitadb.api.requestResponse.data.structure.EntityDecorator;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.dto.PrefetchedPriceForSale;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.AbstractPriceForSaleDataFetcher;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AllPricesForSaleDataFetcher
extends AbstractPriceForSaleDataFetcher<List<? extends PriceContract>> {
    @Nullable
    private static AllPricesForSaleDataFetcher INSTANCE;

    @Nonnull
    public static AllPricesForSaleDataFetcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AllPricesForSaleDataFetcher();
        }
        return INSTANCE;
    }

    @Override
    @Nullable
    protected List<? extends PriceContract> computePrices(@Nonnull EntityDecorator entity, @Nonnull String[] desiredPriceLists, @Nonnull Currency desiredCurrency, @Nullable OffsetDateTime desiredValidIn, @Nonnull PricesContract.AccompanyingPrice[] desiredAccompanyingPrices) {
        List pricesForSale = entity.getAllPricesForSaleWithAccompanyingPrices(desiredCurrency, desiredValidIn, desiredPriceLists, desiredAccompanyingPrices);
        return pricesForSale.stream().map(it -> new PrefetchedPriceForSale(it.priceForSale(), entity, it.accompanyingPrices())).toList();
    }

    private AllPricesForSaleDataFetcher() {
    }
}

