/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.EvitaResponse;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.dataType.DataChunk;
import io.evitadb.dataType.PaginatedList;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecordPageDataFetcher
implements DataFetcher<PaginatedList<? extends EntityClassifier>> {
    @Nullable
    private static RecordPageDataFetcher INSTANCE;

    @Nonnull
    public static RecordPageDataFetcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RecordPageDataFetcher();
        }
        return INSTANCE;
    }

    @Nonnull
    public PaginatedList<? extends EntityClassifier> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        EvitaResponse response = (EvitaResponse)environment.getSource();
        DataChunk records = response.getRecordPage();
        Assert.isPremiseValid((boolean)(records instanceof PaginatedList), () -> new GraphQLQueryResolvingInternalError("Expected paginated list but was `" + String.valueOf(records.getClass()) + "`."));
        return (PaginatedList)records;
    }

    private RecordPageDataFetcher() {
    }
}

