/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint;

import graphql.schema.SelectedField;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.require.Spacing;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.EntityTypePointer;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ManagedEntityTypePointer;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.SegmentDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.model.ResponseDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.ResponseHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import java.util.Optional;
import javax.annotation.Nonnull;

public class PagingRequireResolver {
    @Nonnull
    private final EntitySchemaContract entitySchema;
    @Nonnull
    private final RequireConstraintResolver requireConstraintResolver;

    @Nonnull
    public RequireConstraint resolve(@Nonnull SelectedField recordField) {
        if (recordField.getName().equals(ResponseDescriptor.RECORD_PAGE.name())) {
            Integer pageNumber = recordField.getArguments().getOrDefault(ResponseHeaderDescriptor.RecordPageFieldHeaderDescriptor.NUMBER.name(), 1);
            Integer pageSize = recordField.getArguments().getOrDefault(ResponseHeaderDescriptor.RecordPageFieldHeaderDescriptor.SIZE.name(), 20);
            Spacing spacing = Optional.ofNullable(recordField.getArguments().get(ResponseHeaderDescriptor.RecordPageFieldHeaderDescriptor.SPACING.name())).map(it -> (RequireConstraint)this.requireConstraintResolver.resolve((DataLocator)new SegmentDataLocator((EntityTypePointer)new ManagedEntityTypePointer(this.entitySchema.getName())), ResponseHeaderDescriptor.RecordPageFieldHeaderDescriptor.SPACING.name(), it)).orElse(null);
            return QueryConstraints.page((Integer)pageNumber, (Integer)pageSize, (Spacing)spacing);
        }
        if (recordField.getName().equals(ResponseDescriptor.RECORD_STRIP.name())) {
            Integer offset = recordField.getArguments().getOrDefault(ResponseHeaderDescriptor.RecordStripFieldHeaderDescriptor.OFFSET.name(), 0);
            Integer limit = recordField.getArguments().getOrDefault(ResponseHeaderDescriptor.RecordStripFieldHeaderDescriptor.LIMIT.name(), 20);
            return QueryConstraints.strip((Integer)offset, (Integer)limit);
        }
        throw new GraphQLInternalError("Expected field `" + String.valueOf(ResponseDescriptor.RECORD_PAGE) + "` or `" + String.valueOf(ResponseDescriptor.RECORD_STRIP) + "` but was `" + recordField.getName() + "`.");
    }

    public PagingRequireResolver(@Nonnull EntitySchemaContract entitySchema, @Nonnull RequireConstraintResolver requireConstraintResolver) {
        if (entitySchema == null) {
            throw new NullPointerException("entitySchema is marked non-null but is null");
        }
        if (requireConstraintResolver == null) {
            throw new NullPointerException("requireConstraintResolver is marked non-null but is null");
        }
        this.entitySchema = entitySchema;
        this.requireConstraintResolver = requireConstraintResolver;
    }
}

