/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint;

import graphql.schema.SelectedField;
import io.evitadb.api.query.HierarchyConstraint;
import io.evitadb.api.query.OrderConstraint;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.require.EmptyHierarchicalEntityBehaviour;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.HierarchyFromRoot;
import io.evitadb.api.query.require.HierarchyNode;
import io.evitadb.api.query.require.HierarchyOfReference;
import io.evitadb.api.query.require.HierarchyOfSelf;
import io.evitadb.api.query.require.HierarchyOutputRequireConstraint;
import io.evitadb.api.query.require.HierarchyRequireConstraint;
import io.evitadb.api.query.require.HierarchySiblings;
import io.evitadb.api.query.require.HierarchyStatistics;
import io.evitadb.api.query.require.HierarchyStopAt;
import io.evitadb.api.query.require.StatisticsBase;
import io.evitadb.api.query.require.StatisticsType;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.EntityDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.EntityTypePointer;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.HierarchyDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ManagedEntityTypePointer;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.ExtraResultsDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HierarchyDescriptor;
import io.evitadb.externalApi.api.model.PropertyDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyFromNodeHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyOfDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyOfReferenceHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyOfSelfHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyParentsHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyRequireHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.LevelInfoDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.HierarchyRequireOutputNameResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidResponseUsageException;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HierarchyExtraResultRequireResolver {
    @Nonnull
    private final EntitySchemaContract entitySchema;
    @Nonnull
    private final Function<String, EntitySchemaContract> entitySchemaFetcher;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;
    @Nonnull
    private final OrderConstraintResolver orderConstraintResolver;
    @Nonnull
    private final RequireConstraintResolver requireConstraintResolver;

    @Nonnull
    public Collection<RequireConstraint> resolve(@Nonnull SelectionSetAggregator extraResultsSelectionSet, @Nullable Locale desiredLocale) {
        List<SelectedField> hierarchyFields = extraResultsSelectionSet.getImmediateFields(ExtraResultsDescriptor.HIERARCHY.name());
        if (hierarchyFields.isEmpty()) {
            return List.of();
        }
        return hierarchyFields.stream().flatMap(f -> SelectionSetAggregator.getImmediateFields(f.getSelectionSet()).stream()).map(referenceField -> {
            if (HierarchyDescriptor.SELF.name().equals(referenceField.getName())) {
                return this.resolveHierarchyOfSelf((SelectedField)referenceField, desiredLocale);
            }
            return this.resolveHierarchyOfReference((SelectedField)referenceField, desiredLocale);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (c, c2) -> {
            throw new GraphQLInvalidResponseUsageException("Duplicate hierarchies for single reference.");
        })).values();
    }

    @Nonnull
    private Map.Entry<String, RequireConstraint> resolveHierarchyOfSelf(@Nonnull SelectedField field, @Nullable Locale desiredLocale) {
        OrderBy orderBy = Optional.ofNullable(field.getArguments().get(HierarchyOfSelfHeaderDescriptor.ORDER_BY.name())).map(it -> (OrderConstraint)this.orderConstraintResolver.resolve((DataLocator)new EntityDataLocator((EntityTypePointer)new ManagedEntityTypePointer(this.entitySchema.getName())), HierarchyOfSelfHeaderDescriptor.ORDER_BY.name(), it)).orElse(null);
        HierarchyRequireConstraint[] hierarchyRequires = this.resolveHierarchyRequirements(field, this.entitySchema, (DataLocator)new HierarchyDataLocator((EntityTypePointer)new ManagedEntityTypePointer(this.entitySchema.getName())), desiredLocale);
        HierarchyOfSelf hierarchyOfSelf = QueryConstraints.hierarchyOfSelf((OrderBy)orderBy, (HierarchyRequireConstraint[])hierarchyRequires);
        return new AbstractMap.SimpleEntry<String, HierarchyOfSelf>(HierarchyDescriptor.SELF.name(), hierarchyOfSelf);
    }

    @Nonnull
    private Map.Entry<String, RequireConstraint> resolveHierarchyOfReference(@Nonnull SelectedField field, @Nullable Locale desiredLocale) {
        ReferenceSchemaContract referenceSchema = (ReferenceSchemaContract)this.entitySchema.getReferenceByName(field.getName(), ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION).orElseThrow(() -> new GraphQLQueryResolvingInternalError("Could not find reference `" + field.getName() + "` in `" + this.entitySchema.getName() + "`."));
        String referenceName = referenceSchema.getName();
        EntitySchemaContract hierarchyEntitySchema = referenceSchema.isReferencedEntityTypeManaged() ? this.entitySchemaFetcher.apply(referenceSchema.getReferencedEntityType()) : null;
        EmptyHierarchicalEntityBehaviour emptyHierarchicalEntityBehaviour = (EmptyHierarchicalEntityBehaviour)field.getArguments().get(HierarchyOfReferenceHeaderDescriptor.EMPTY_HIERARCHICAL_ENTITY_BEHAVIOUR.name());
        OrderBy orderBy = referenceSchema.isReferencedEntityTypeManaged() ? (OrderBy)Optional.ofNullable(field.getArguments().get(HierarchyOfReferenceHeaderDescriptor.ORDER_BY.name())).map(it -> (OrderConstraint)this.orderConstraintResolver.resolve((DataLocator)new EntityDataLocator((EntityTypePointer)new ManagedEntityTypePointer(hierarchyEntitySchema.getName())), HierarchyOfReferenceHeaderDescriptor.ORDER_BY.name(), it)).orElse(null) : null;
        HierarchyRequireConstraint[] hierarchyRequires = this.resolveHierarchyRequirements(field, hierarchyEntitySchema, (DataLocator)new HierarchyDataLocator((EntityTypePointer)new ManagedEntityTypePointer(this.entitySchema.getName()), referenceName), desiredLocale);
        HierarchyOfReference hierarchyOfReference = QueryConstraints.hierarchyOfReference((String)referenceName, (EmptyHierarchicalEntityBehaviour)emptyHierarchicalEntityBehaviour, (OrderBy)orderBy, (HierarchyRequireConstraint[])hierarchyRequires);
        return new AbstractMap.SimpleEntry<String, HierarchyOfReference>(referenceName, hierarchyOfReference);
    }

    @Nonnull
    private HierarchyRequireConstraint[] resolveHierarchyRequirements(@Nonnull SelectedField field, @Nullable EntitySchemaContract hierarchyEntitySchema, @Nonnull DataLocator hierarchyDataLocator, @Nullable Locale desiredLocale) {
        return (HierarchyRequireConstraint[])field.getSelectionSet().getImmediateFields().stream().map(specificHierarchyField -> this.resolveHierarchyRequire((SelectedField)specificHierarchyField, hierarchyEntitySchema, hierarchyDataLocator, desiredLocale)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (c, c2) -> {
            throw new GraphQLInvalidResponseUsageException("Duplicate hierarchy output name `" + c.getOutputName() + "`.");
        })).values().toArray(HierarchyRequireConstraint[]::new);
    }

    @Nonnull
    private Map.Entry<String, HierarchyRequireConstraint> resolveHierarchyRequire(@Nonnull SelectedField field, @Nullable EntitySchemaContract hierarchyEntitySchema, @Nonnull DataLocator hierarchyDataLocator, @Nullable Locale desiredLocale) {
        HierarchyFromRoot hierarchyRequire;
        String outputName = HierarchyRequireOutputNameResolver.resolve(field);
        String hierarchyType = field.getName();
        HierarchyStopAt stopAt = (HierarchyStopAt)this.resolveChildHierarchyRequireFromArgument(field, hierarchyDataLocator, HierarchyRequireHeaderDescriptor.STOP_AT);
        HierarchyStatistics statistics = this.resolveHierarchyStatistics(field);
        EntityFetch entityFetch = this.resolveHierarchyEntityFetch(field, hierarchyEntitySchema, desiredLocale);
        if (HierarchyOfDescriptor.FROM_ROOT.name().equals(hierarchyType)) {
            hierarchyRequire = QueryConstraints.fromRoot((String)outputName, (EntityFetch)entityFetch, (HierarchyOutputRequireConstraint[])new HierarchyOutputRequireConstraint[]{stopAt, statistics});
        } else if (HierarchyOfDescriptor.FROM_NODE.name().equals(hierarchyType)) {
            HierarchyNode node = (HierarchyNode)this.resolveChildHierarchyRequireFromArgument(field, hierarchyDataLocator, HierarchyFromNodeHeaderDescriptor.NODE);
            Assert.isPremiseValid((node != null ? 1 : 0) != 0, () -> new GraphQLQueryResolvingInternalError("Missing `" + HierarchyFromNodeHeaderDescriptor.NODE.name() + "` argument."));
            hierarchyRequire = QueryConstraints.fromNode((String)outputName, (HierarchyNode)node, (EntityFetch)entityFetch, (HierarchyOutputRequireConstraint[])new HierarchyOutputRequireConstraint[]{stopAt, statistics});
        } else if (HierarchyOfDescriptor.CHILDREN.name().equals(hierarchyType)) {
            hierarchyRequire = QueryConstraints.children((String)outputName, (EntityFetch)entityFetch, (HierarchyOutputRequireConstraint[])new HierarchyOutputRequireConstraint[]{stopAt, statistics});
        } else if (HierarchyOfDescriptor.PARENTS.name().equals(hierarchyType)) {
            HierarchySiblings siblings = this.resolveSiblingsOfParents(field, hierarchyDataLocator);
            hierarchyRequire = QueryConstraints.parents((String)outputName, (EntityFetch)entityFetch, (HierarchySiblings)siblings, (HierarchyOutputRequireConstraint[])new HierarchyOutputRequireConstraint[]{stopAt, statistics});
        } else if (HierarchyOfDescriptor.SIBLINGS.name().equals(hierarchyType)) {
            hierarchyRequire = QueryConstraints.siblings((String)outputName, (EntityFetch)entityFetch, (HierarchyOutputRequireConstraint[])new HierarchyOutputRequireConstraint[]{stopAt, statistics});
        } else {
            throw new GraphQLQueryResolvingInternalError("Unsupported hierarchy type `" + hierarchyType + "`.");
        }
        return new AbstractMap.SimpleEntry<String, HierarchyFromRoot>(outputName, hierarchyRequire);
    }

    @Nullable
    private <T extends HierarchyConstraint<RequireConstraint>> T resolveChildHierarchyRequireFromArgument(@Nonnull SelectedField field, @Nonnull DataLocator hierarchyDataLocator, @Nonnull PropertyDescriptor argumentDescriptor) {
        return (T)((HierarchyConstraint)Optional.ofNullable(field.getArguments().get(argumentDescriptor.name())).map(it -> (RequireConstraint)this.requireConstraintResolver.resolve(hierarchyDataLocator, hierarchyDataLocator, argumentDescriptor.name(), it)).orElse(null));
    }

    @Nullable
    private EntityFetch resolveHierarchyEntityFetch(@Nonnull SelectedField field, @Nullable EntitySchemaContract hierarchyEntitySchema, @Nullable Locale desiredLocale) {
        return this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(SelectionSetAggregator.getImmediateFields(LevelInfoDescriptor.ENTITY.name(), field.getSelectionSet()).stream().map(SelectedField::getSelectionSet).toList()), desiredLocale, hierarchyEntitySchema).orElse(null);
    }

    @Nullable
    private HierarchyStatistics resolveHierarchyStatistics(@Nonnull SelectedField field) {
        HashSet statisticsTypes = CollectionUtils.createHashSet((int)2);
        if (SelectionSetAggregator.containsImmediate(LevelInfoDescriptor.CHILDREN_COUNT.name(), field.getSelectionSet())) {
            statisticsTypes.add(StatisticsType.CHILDREN_COUNT);
        }
        if (SelectionSetAggregator.containsImmediate(LevelInfoDescriptor.QUERIED_ENTITY_COUNT.name(), field.getSelectionSet())) {
            statisticsTypes.add(StatisticsType.QUERIED_ENTITY_COUNT);
        }
        if (SelectionSetAggregator.isEmpty(field.getSelectionSet())) {
            return null;
        }
        Optional<StatisticsBase> statisticsBase = Optional.ofNullable(field.getArguments().get(HierarchyRequireHeaderDescriptor.STATISTICS_BASE.name())).map(it -> (StatisticsBase)it);
        return QueryConstraints.statistics((StatisticsBase)statisticsBase.orElse(StatisticsBase.WITHOUT_USER_FILTER), (StatisticsType[])((StatisticsType[])statisticsTypes.toArray(StatisticsType[]::new)));
    }

    @Nullable
    private HierarchySiblings resolveSiblingsOfParents(@Nonnull SelectedField field, @Nonnull DataLocator hierarchyDataLocator) {
        Map siblingsSpecification = (Map)field.getArguments().get(HierarchyParentsHeaderDescriptor.SIBLINGS.name());
        if (siblingsSpecification == null) {
            return null;
        }
        HierarchyStopAt stopAt = Optional.ofNullable(siblingsSpecification.get(HierarchyParentsHeaderDescriptor.HierarchyParentsSiblingsSpecification.STOP_AT.name())).map(it -> (HierarchyStopAt)this.requireConstraintResolver.resolve(hierarchyDataLocator, hierarchyDataLocator, HierarchyParentsHeaderDescriptor.HierarchyParentsSiblingsSpecification.STOP_AT.name(), it)).orElse(null);
        return new HierarchySiblings(null, new HierarchyOutputRequireConstraint[]{stopAt});
    }

    public HierarchyExtraResultRequireResolver(@Nonnull EntitySchemaContract entitySchema, @Nonnull Function<String, EntitySchemaContract> entitySchemaFetcher, @Nonnull EntityFetchRequireResolver entityFetchRequireResolver, @Nonnull OrderConstraintResolver orderConstraintResolver, @Nonnull RequireConstraintResolver requireConstraintResolver) {
        if (entitySchema == null) {
            throw new NullPointerException("entitySchema is marked non-null but is null");
        }
        if (entitySchemaFetcher == null) {
            throw new NullPointerException("entitySchemaFetcher is marked non-null but is null");
        }
        if (entityFetchRequireResolver == null) {
            throw new NullPointerException("entityFetchRequireResolver is marked non-null but is null");
        }
        if (orderConstraintResolver == null) {
            throw new NullPointerException("orderConstraintResolver is marked non-null but is null");
        }
        if (requireConstraintResolver == null) {
            throw new NullPointerException("requireConstraintResolver is marked non-null but is null");
        }
        this.entitySchema = entitySchema;
        this.entitySchemaFetcher = entitySchemaFetcher;
        this.entityFetchRequireResolver = entityFetchRequireResolver;
        this.orderConstraintResolver = orderConstraintResolver;
        this.requireConstraintResolver = requireConstraintResolver;
    }
}

