/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.descriptor.ConstraintCreator;
import io.evitadb.api.query.descriptor.ConstraintDescriptor;
import io.evitadb.api.query.descriptor.ConstraintDescriptorProvider;
import io.evitadb.api.query.descriptor.ConstraintPropertyType;
import io.evitadb.api.query.descriptor.ConstraintType;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.AllowedConstraintPredicate;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.ConstraintBuildContext;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.ConstraintSchemaBuilder;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.ConstraintSchemaBuildingContext;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.ContainerKey;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.WrapperObjectKey;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ConstraintProcessingUtils;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ConstraintTraverseContext;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.model.CatalogDataApiRootDescriptor;
import io.evitadb.externalApi.exception.ExternalApiInternalError;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.GraphQLConstraintSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.graphql.api.dataType.GraphQLScalars;
import io.evitadb.externalApi.graphql.exception.GraphQLSchemaBuildingError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.ClassUtils;
import io.evitadb.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class GraphQLConstraintSchemaBuilder
extends ConstraintSchemaBuilder<GraphQLConstraintSchemaBuildingContext, GraphQLInputType, GraphQLInputType, GraphQLInputObjectField> {
    protected GraphQLConstraintSchemaBuilder(@Nonnull GraphQLConstraintSchemaBuildingContext sharedContext, @Nonnull Map<ConstraintType, AtomicReference<? extends ConstraintSchemaBuilder<GraphQLConstraintSchemaBuildingContext, GraphQLInputType, GraphQLInputType, GraphQLInputObjectField>>> additionalBuilders, @Nonnull Set<Class<? extends Constraint<?>>> allowedConstraints, @Nonnull Set<Class<? extends Constraint<?>>> forbiddenConstraints) {
        super((ConstraintSchemaBuildingContext)sharedContext, additionalBuilders, allowedConstraints, forbiddenConstraints);
    }

    @Nonnull
    protected GraphQLInputType buildContainer(@Nonnull ConstraintBuildContext buildContext, @Nonnull ContainerKey containerKey, @Nonnull AllowedConstraintPredicate allowedChildrenPredicate) {
        String containerName = this.constructContainerName(containerKey);
        GraphQLInputObjectType.Builder containerBuilder = GraphQLInputObjectType.newInputObject().name(containerName);
        GraphQLTypeReference containerPointer = GraphQLTypeReference.typeRef((String)containerName);
        ((GraphQLConstraintSchemaBuildingContext)this.sharedContext).cacheContainer(containerKey, containerPointer);
        LinkedList children = new LinkedList();
        children.addAll(this.buildGenericChildren(buildContext, allowedChildrenPredicate));
        children.addAll(this.buildEntityChildren(buildContext, allowedChildrenPredicate));
        children.addAll(this.buildAttributeChildren(buildContext, allowedChildrenPredicate));
        children.addAll(this.buildAssociatedDataChildren(buildContext, allowedChildrenPredicate));
        children.addAll(this.buildPriceChildren(buildContext, allowedChildrenPredicate));
        Collection referenceSchemas = this.findReferenceSchemas(buildContext.dataLocator());
        children.addAll(this.buildReferenceChildren(buildContext, allowedChildrenPredicate, referenceSchemas));
        children.addAll(this.buildHierarchyChildren(buildContext, allowedChildrenPredicate, referenceSchemas));
        children.addAll(this.buildFacetChildren(buildContext, allowedChildrenPredicate, referenceSchemas));
        if (children.isEmpty()) {
            ((GraphQLConstraintSchemaBuildingContext)this.sharedContext).removeCachedContainer(containerKey);
            return this.buildNoneConstraintValue();
        }
        children.forEach(field -> {
            Assert.isPremiseValid((!containerBuilder.hasField(field.getName()) ? 1 : 0) != 0, () -> this.createSchemaBuildingError("There is already defined field `" + field.getName() + "` in container name `" + containerName + "`."));
            containerBuilder.field(field);
        });
        ((GraphQLConstraintSchemaBuildingContext)this.sharedContext).addNewType(containerBuilder.build());
        return containerPointer;
    }

    @Nullable
    protected GraphQLInputObjectField buildFieldFromConstraintDescriptor(@Nonnull ConstraintDescriptor constraintDescriptor, @Nonnull String constraintKey, @Nonnull GraphQLInputType constraintValue) {
        return GraphQLInputObjectField.newInputObjectField().name(constraintKey).description(this.constructConstraintDescription(constraintDescriptor)).type(constraintValue).build();
    }

    @Nonnull
    protected GraphQLInputType buildNoneConstraintValue() {
        return this.resolveGraphQLType(Boolean.class, false);
    }

    @Nonnull
    protected GraphQLInputType buildPrimitiveConstraintValue(@Nonnull ConstraintBuildContext buildContext, @Nonnull ConstraintCreator.ValueParameterDescriptor valueParameter, boolean canBeRequired, @Nullable ConstraintSchemaBuilder.ValueTypeSupplier valueTypeSupplier) {
        Class valueParameterType = valueParameter.type();
        if (this.isJavaTypeGeneric(valueParameterType)) {
            Assert.isPremiseValid((valueTypeSupplier != null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("Value parameter `" + valueParameter.name() + "` has generic type but no value type supplier is present."));
            Class suppliedValueType = (Class)valueTypeSupplier.apply((Object)valueParameter);
            Assert.isPremiseValid((suppliedValueType != null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("Expected value type supplier to supply type not null."));
            return this.resolveGraphQLType(valueParameterType, suppliedValueType, canBeRequired && valueParameter.required());
        }
        if (Locale.class.equals((Object)valueParameterType) || Locale.class.equals(valueParameterType.getComponentType())) {
            return DataTypesConverter.wrapGraphQLComponentType(GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name()), valueParameterType, canBeRequired && valueParameter.required());
        }
        if (Currency.class.equals((Object)valueParameterType) || Currency.class.equals(valueParameterType.getComponentType())) {
            return DataTypesConverter.wrapGraphQLComponentType(GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.CURRENCY_ENUM.name()), valueParameterType, canBeRequired && valueParameter.required());
        }
        return this.resolveGraphQLType(valueParameterType, canBeRequired && valueParameter.required());
    }

    @Nonnull
    protected GraphQLInputType buildWrapperRangeConstraintValue(@Nonnull ConstraintBuildContext buildContext, @Nonnull List<ConstraintCreator.ValueParameterDescriptor> valueParameters, @Nullable ConstraintSchemaBuilder.ValueTypeSupplier valueTypeSupplier) {
        boolean itemsAreRequired = valueParameters.get(0).required() && valueParameters.get(1).required();
        GraphQLInputType itemType = this.buildPrimitiveConstraintValue(buildContext, valueParameters.get(0), itemsAreRequired, valueTypeSupplier);
        return GraphQLList.list((GraphQLType)itemType);
    }

    @Nonnull
    protected Map<String, GraphQLInputType> buildChildConstraintValue(@Nonnull ConstraintBuildContext buildContext, @Nonnull ConstraintCreator.ChildParameterDescriptor childParameter) {
        Optional childDataLocator = this.resolveChildDataLocator(buildContext, childParameter.domain());
        if (childDataLocator.isEmpty()) {
            return Map.of();
        }
        ConstraintBuildContext childBuildContext = buildContext.switchToChildContext((DataLocator)childDataLocator.get());
        LinkedHashMap childTypes = CollectionUtils.createLinkedHashMap((int)1);
        Class childParameterType = childParameter.type();
        if (!childParameterType.isArray() && !ClassUtils.isAbstract((Class)childParameterType)) {
            ConstraintDescriptorProvider.getConstraints((Class)childParameterType).forEach(childConstraintDescriptor -> {
                String key = this.keyBuilder.build((ConstraintTraverseContext)buildContext, childConstraintDescriptor, null);
                Optional childConstraintDataLocator = this.resolveChildDataLocator(buildContext, ConstraintProcessingUtils.getDomainForPropertyType((ConstraintPropertyType)childConstraintDescriptor.propertyType()));
                if (childConstraintDataLocator.isEmpty()) {
                    return;
                }
                childTypes.put(key, (GraphQLInputType)this.build(childBuildContext.switchToChildContext((DataLocator)childConstraintDataLocator.get()), (ConstraintDescriptor)childConstraintDescriptor));
            });
        } else {
            GraphQLInputType childType = (GraphQLInputType)this.obtainContainer(childBuildContext, childParameter);
            if (childType.equals(GraphQLScalars.BOOLEAN)) {
                childTypes.put("_", childType);
            } else if (childParameter.type().isArray() && !childParameter.uniqueChildren()) {
                childTypes.put("_", GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)childType)));
            } else {
                childTypes.put("_", childType);
            }
        }
        return childTypes;
    }

    @Nullable
    protected GraphQLInputType buildWrapperObjectConstraintValue(@Nonnull ConstraintBuildContext buildContext, @Nonnull WrapperObjectKey wrapperObjectKey, @Nonnull List<ConstraintCreator.ValueParameterDescriptor> valueParameters, @Nonnull List<ConstraintCreator.ChildParameterDescriptor> childParameters, @Nonnull List<ConstraintCreator.AdditionalChildParameterDescriptor> additionalChildParameters, @Nullable ConstraintSchemaBuilder.ValueTypeSupplier valueTypeSupplier) {
        ArrayList<GraphQLInputObjectField.Builder> wrapperObjectFields = new ArrayList<GraphQLInputObjectField.Builder>(valueParameters.size() + childParameters.size() + additionalChildParameters.size());
        Iterator<ConstraintCreator.ValueParameterDescriptor> iterator = valueParameters.iterator();
        while (iterator.hasNext()) {
            ConstraintCreator.ValueParameterDescriptor valueParameter;
            GraphQLInputType nestedPrimitiveConstraintValue = this.buildPrimitiveConstraintValue(buildContext, valueParameter, !(valueParameter = iterator.next()).type().isArray(), valueTypeSupplier);
            wrapperObjectFields.add(GraphQLInputObjectField.newInputObjectField().name(valueParameter.name()).type(nestedPrimitiveConstraintValue));
        }
        childParameters.forEach(childParameter -> {
            Map<String, GraphQLInputType> nestedChildConstraints = this.buildChildConstraintValue(buildContext, (ConstraintCreator.ChildParameterDescriptor)childParameter);
            if (nestedChildConstraints.isEmpty()) {
                return;
            }
            if (nestedChildConstraints.size() == 1) {
                GraphQLInputType nestedChildConstraintValue = nestedChildConstraints.values().iterator().next();
                if (childParameter.required() && !childParameter.type().isArray()) {
                    nestedChildConstraintValue = GraphQLNonNull.nonNull((GraphQLType)nestedChildConstraintValue);
                }
                wrapperObjectFields.add(GraphQLInputObjectField.newInputObjectField().name(childParameter.name()).type(nestedChildConstraintValue));
            } else {
                nestedChildConstraints.entrySet().forEach(nestedChildConstraint -> {
                    String key = (String)nestedChildConstraint.getKey();
                    Assert.isPremiseValid((!key.equals("_") ? 1 : 0) != 0, () -> this.createSchemaBuildingError("Multiple nested child constraint variants but missing proper key."));
                    if (childParameter.required() && !childParameter.type().isArray()) {
                        nestedChildConstraint.setValue(GraphQLNonNull.nonNull((GraphQLType)((GraphQLType)nestedChildConstraint.getValue())));
                    }
                    wrapperObjectFields.add(GraphQLInputObjectField.newInputObjectField().name(key).type((GraphQLInputType)nestedChildConstraint.getValue()));
                });
            }
        });
        additionalChildParameters.forEach(additionalChildParameter -> this.buildAdditionalChildConstraintValue(buildContext, (ConstraintCreator.AdditionalChildParameterDescriptor)additionalChildParameter).ifPresent(nestedAdditionalChildConstraintValue -> {
            if (additionalChildParameter.required() && !additionalChildParameter.type().isArray()) {
                nestedAdditionalChildConstraintValue = GraphQLNonNull.nonNull((GraphQLType)nestedAdditionalChildConstraintValue);
            }
            wrapperObjectFields.add(GraphQLInputObjectField.newInputObjectField().name(additionalChildParameter.name()).type(nestedAdditionalChildConstraintValue));
        }));
        if (wrapperObjectFields.isEmpty()) {
            return null;
        }
        String wrapperObjectName = this.constructWrapperObjectName(wrapperObjectKey);
        GraphQLInputObjectType.Builder wrapperObjectBuilder = GraphQLInputObjectType.newInputObject().name(wrapperObjectName);
        wrapperObjectFields.forEach(arg_0 -> ((GraphQLInputObjectType.Builder)wrapperObjectBuilder).field(arg_0));
        GraphQLTypeReference wrapperObjectPointer = GraphQLTypeReference.typeRef((String)wrapperObjectName);
        ((GraphQLConstraintSchemaBuildingContext)this.sharedContext).cacheWrapperObject(wrapperObjectKey, wrapperObjectPointer);
        ((GraphQLConstraintSchemaBuildingContext)this.sharedContext).addNewType(wrapperObjectBuilder.build());
        return wrapperObjectPointer;
    }

    @Nonnull
    private GraphQLInputType resolveGraphQLType(@Nonnull Class<?> valueType, boolean nonNull) {
        if (this.isJavaTypeEnum(valueType)) {
            DataTypesConverter.ConvertedEnum convertedEnum = DataTypesConverter.getGraphQLEnumType(valueType, nonNull);
            ((GraphQLConstraintSchemaBuildingContext)this.sharedContext).getCatalogCtx().registerCustomEnumIfAbsent(convertedEnum.enumType());
            return convertedEnum.resultType();
        }
        return DataTypesConverter.getGraphQLScalarType(valueType, nonNull);
    }

    @Nonnull
    private GraphQLInputType resolveGraphQLType(@Nonnull Class<?> valueType, @Nonnull Class<?> replacementComponentType, boolean nonNull) {
        if (this.isJavaTypeEnum(replacementComponentType)) {
            DataTypesConverter.ConvertedEnum convertedEnum = DataTypesConverter.getGraphQLEnumType(valueType, replacementComponentType, nonNull);
            ((GraphQLConstraintSchemaBuildingContext)this.sharedContext).getCatalogCtx().registerCustomEnumIfAbsent(convertedEnum.enumType());
            return convertedEnum.resultType();
        }
        return DataTypesConverter.getGraphQLScalarType(valueType, replacementComponentType, nonNull);
    }

    protected <T extends ExternalApiInternalError> T createSchemaBuildingError(@Nonnull String message) {
        return (T)((Object)new GraphQLSchemaBuildingError(message));
    }
}

