/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog;

import graphql.ExecutionResult;
import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.language.OperationDefinition;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.exception.RollbackException;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class EvitaSessionManagingInstrumentation
extends SimplePerformantInstrumentation {
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final String catalogName;

    @Nullable
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(@Nonnull InstrumentationExecuteOperationParameters parameters, @Nonnull InstrumentationState state) {
        EvitaSessionContract evitaSession;
        ExecutionContext executionContext = parameters.getExecutionContext();
        OperationDefinition.Operation operation = executionContext.getOperationDefinition().getOperation();
        if (operation == OperationDefinition.Operation.QUERY) {
            evitaSession = this.evita.createReadOnlySession(this.catalogName);
        } else if (operation == OperationDefinition.Operation.MUTATION) {
            evitaSession = this.evita.createReadWriteSession(this.catalogName);
        } else {
            throw new GraphQLInternalError("Operation `" + String.valueOf(operation) + "` is currently not supported by evitaDB GraphQL API.");
        }
        executionContext.getGraphQLContext().put((Object)GraphQLContextKey.EVITA_SESSION, (Object)evitaSession);
        return SimpleInstrumentationContext.noOp();
    }

    @Nonnull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(@Nonnull ExecutionResult executionResult, @Nonnull InstrumentationExecutionParameters parameters, @Nonnull InstrumentationState state) {
        EvitaSessionContract evitaSession = (EvitaSessionContract)parameters.getGraphQLContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        if (evitaSession != null) {
            try {
                evitaSession.close();
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
        }
        return CompletableFuture.completedFuture(executionResult);
    }

    public EvitaSessionManagingInstrumentation(@Nonnull Evita evita, @Nonnull String catalogName) {
        if (evita == null) {
            throw new NullPointerException("evita is marked non-null but is null");
        }
        if (catalogName == null) {
            throw new NullPointerException("catalogName is marked non-null but is null");
        }
        this.evita = evita;
        this.catalogName = catalogName;
    }
}

