/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis.command;

import io.enoa.nosql.redis.EnoaRedisConvert;
import io.enoa.nosql.redis.command._Runner;
import java.util.List;
import redis.clients.jedis.BitOP;
import redis.clients.util.SafeEncoder;

interface StringCommand
extends _Runner {
    default public Long append(String key, String value) {
        return (Long)this.run((jedis, serializer) -> jedis.append(key, value));
    }

    default public Long bitcount(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.bitcount(SafeEncoder.encode((String)key)));
    }

    default public Long bitcount(String key, long start, long end) {
        return (Long)this.run((jedis, serializer) -> jedis.bitcount(SafeEncoder.encode((String)key), start, end));
    }

    default public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        return (Long)this.run((jedis, serializer) -> jedis.bitop(op, destKey, srcKeys));
    }

    default public List<Long> bitfield(String key, String ... arguments) {
        return (List)this.run((jedis, serializer) -> jedis.bitfield(key, arguments));
    }

    default public Long decr(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.decr(key));
    }

    default public Long decrby(String key, long integer) {
        return (Long)this.run((jedis, serializer) -> jedis.decrBy(key, integer));
    }

    default public String get(String key) {
        return (String)this.run((jedis, serializer) -> jedis.get(key));
    }

    default public Boolean getbit(String key, long offset) {
        return (Boolean)this.run((jedis, serializer) -> jedis.getbit(key, offset));
    }

    default public String getrange(String key, long startOffset, long endOffset) {
        return (String)this.run((jedis, serializer) -> jedis.getrange(key, startOffset, endOffset));
    }

    default public String getset(String key, String value) {
        return (String)this.run((jedis, serializer) -> jedis.getSet(key, value));
    }

    default public Long incr(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.incr(key));
    }

    default public Long incrby(String key, long integer) {
        return (Long)this.run((jedis, serializer) -> jedis.incrBy(key, integer));
    }

    default public Double incrbyfloat(String key, double value) {
        return (Double)this.run((jedis, serializer) -> jedis.incrByFloat(key, value));
    }

    default public List<String> mget(String ... keys) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.mget(EnoaRedisConvert.with(serializer).toBytesKeys(keys))));
    }

    default public String mset(String ... keysvalues) {
        if (keysvalues.length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for met, keysValues length can not be odd");
        }
        return (String)this.run((jedis, serializer) -> jedis.mset(keysvalues));
    }

    default public Long msetnx(String ... keysvalues) {
        if (keysvalues.length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for met, keysValues length can not be odd");
        }
        return (Long)this.run((jedis, serializer) -> jedis.msetnx(keysvalues));
    }

    default public String psetex(String key, long milliseconds, String value) {
        return (String)this.run((jedis, serializer) -> jedis.psetex(key, milliseconds, value));
    }

    default public String set(String key, String value) {
        return (String)this.run((jedis, serializer) -> jedis.set(key, value));
    }

    default public String set(String key, String value, String nxxx) {
        return (String)this.run((jedis, serializer) -> jedis.set(key, value, nxxx));
    }

    default public String set(String key, String value, String nxxx, String expx, int time) {
        return (String)this.run((jedis, serializer) -> jedis.set(key, value, nxxx, expx, time));
    }

    default public Boolean setbit(String key, long offset, String value) {
        return (Boolean)this.run((jedis, serializer) -> jedis.setbit(key, offset, value));
    }

    default public String setex(String key, int seconds, String value) {
        return (String)this.run((jedis, serializer) -> jedis.setex(key, seconds, value));
    }

    default public Long setnx(String key, String value) {
        return (Long)this.run((jedis, serializer) -> jedis.setnx(key, value));
    }

    default public Long setrange(String key, long offset, String value) {
        return (Long)this.run((jedis, serializer) -> jedis.setrange(key, offset, value));
    }

    default public Long strlen(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.strlen(key));
    }
}

