/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis.command;

import io.enoa.nosql.redis.EnoaRedisConvert;
import io.enoa.nosql.redis.command._Runner;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.SafeEncoder;

interface SortSetCommand
extends _Runner {
    default public Long zadd(String key, double score, Object member) {
        return (Long)this.run((jedis, serializer) -> jedis.zadd(SafeEncoder.encode((String)key), score, serializer.serialize(member)));
    }

    default public Long zadd(String key, double score, Object member, ZAddParams params) {
        return (Long)this.run((jedis, serializer) -> jedis.zadd(SafeEncoder.encode((String)key), score, serializer.serialize(member), params));
    }

    default public Long zadd(String key, Map<String, Double> scoreMembers) {
        return (Long)this.run((jedis, serializer) -> jedis.zadd(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesZmap(scoreMembers)));
    }

    default public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        return (Long)this.run((jedis, serializer) -> jedis.zadd(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesZmap(scoreMembers), params));
    }

    default public Long zcard(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.zcard(key));
    }

    default public Long zcount(String key, double min, double max) {
        return (Long)this.run((jedis, serializer) -> jedis.zcount(key, min, max));
    }

    default public Long zcount(String key, Object min, Object max) {
        return (Long)this.run((jedis, serializer) -> jedis.zcount(SafeEncoder.encode((String)key), serializer.serialize(min), serializer.serialize(max)));
    }

    default public Double zincrby(String key, double score, Object member) {
        return (Double)this.run((jedis, serializer) -> jedis.zincrby(SafeEncoder.encode((String)key), score, serializer.serialize(member)));
    }

    default public Double zincrby(String key, double score, Object member, ZIncrByParams params) {
        return (Double)this.run((jedis, serializer) -> jedis.zincrby(SafeEncoder.encode((String)key), score, serializer.serialize(member), params));
    }

    default public <T> Set<T> zrange(String key, long start, long end) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrange(SafeEncoder.encode((String)key), start, end)));
    }

    default public <T> Set<T> zrangebyscore(String key, double min, double max) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrangeByScore(SafeEncoder.encode((String)key), min, max)));
    }

    default public <T> Set<T> zrangebyscore(String key, T min, T max) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrangeByScore(SafeEncoder.encode((String)key), serializer.serialize(min), serializer.serialize(max))));
    }

    default public <T> Set<T> zrangebyscore(String key, double min, double max, int offset, int count) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrangeByScore(SafeEncoder.encode((String)key), min, max, offset, count)));
    }

    default public <T> Set<T> zrangebyscore(String key, T min, T max, int offset, int count) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrangeByScore(SafeEncoder.encode((String)key), serializer.serialize(min), serializer.serialize(max), offset, count)));
    }

    default public Long zrank(String key, Object member) {
        return (Long)this.run((jedis, serializer) -> jedis.zrank(SafeEncoder.encode((String)key), serializer.serialize(member)));
    }

    default public Long zrem(String key, Object ... member) {
        return (Long)this.run((jedis, serializer) -> jedis.zrem(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesValues(member)));
    }

    default public Long zremrangebyrank(String key, long start, long end) {
        return (Long)this.run((jedis, serializer) -> jedis.zremrangeByRank(key, start, end));
    }

    default public Long zremrangebyscore(String key, double start, double end) {
        return (Long)this.run((jedis, serializer) -> jedis.zremrangeByScore(key, start, end));
    }

    default public Long zremrangebyscore(String key, Object start, Object end) {
        return (Long)this.run((jedis, serializer) -> jedis.zremrangeByScore(SafeEncoder.encode((String)key), serializer.serialize(start), serializer.serialize(end)));
    }

    default public <T> Set<T> zrevrange(String key, long start, long end) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrevrange(SafeEncoder.encode((String)key), start, end)));
    }

    default public <T> Set<T> zrevrangebylex(String key, T max, T min) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrevrangeByLex(SafeEncoder.encode((String)key), serializer.serialize(max), serializer.serialize(min))));
    }

    default public <T> Set<T> zrevrangebylex(String key, T max, T min, int offset, int count) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrevrangeByLex(SafeEncoder.encode((String)key), serializer.serialize(max), serializer.serialize(min), offset, count)));
    }

    default public <T> Set<T> zrevrangebyscore(String key, double max, double min) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrevrangeByScore(SafeEncoder.encode((String)key), max, min)));
    }

    default public <T> Set<T> zrevrangebyscore(String key, T max, T min) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrevrangeByScore(SafeEncoder.encode((String)key), serializer.serialize(max), serializer.serialize(min))));
    }

    default public <T> Set<T> zrevrangebyscore(String key, double max, double min, int offset, int count) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrevrangeByScore(SafeEncoder.encode((String)key), max, min, offset, count)));
    }

    default public <T> Set<T> zrevrangebyscore(String key, T max, T min, int offset, int count) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrevrangeByScore(SafeEncoder.encode((String)key), serializer.serialize(max), serializer.serialize(min), offset, count)));
    }

    default public Long zrevrank(String key, Object member) {
        return (Long)this.run((jedis, serializer) -> jedis.zrevrank(SafeEncoder.encode((String)key), serializer.serialize(member)));
    }

    default public Double zscore(String key, Object member) {
        return (Double)this.run((jedis, serializer) -> jedis.zscore(SafeEncoder.encode((String)key), serializer.serialize(member)));
    }

    default public Long zunionstore(String dstkey, String ... sets) {
        return (Long)this.run((jedis, serializer) -> jedis.zunionstore(dstkey, sets));
    }

    default public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        return (Long)this.run((jedis, serializer) -> jedis.zunionstore(dstkey, params, sets));
    }

    default public Long zinterstore(String dstkey, String ... sets) {
        return (Long)this.run((jedis, serializer) -> jedis.zinterstore(dstkey, sets));
    }

    default public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        return (Long)this.run((jedis, serializer) -> jedis.zinterstore(dstkey, params, sets));
    }

    default public ScanResult<Tuple> zscan(String key, String cursor) {
        return (ScanResult)this.run((jedis, serializer) -> jedis.zscan(key, cursor));
    }

    default public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        return (ScanResult)this.run((jedis, serializer) -> jedis.zscan(key, cursor, params));
    }

    default public <T> Set<T> zrangebylex(String key, T min, T max) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrangeByLex(SafeEncoder.encode((String)key), serializer.serialize(min), serializer.serialize(max))));
    }

    default public <T> Set<T> zrangebylex(String key, T min, T max, int offset, int count) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.zrangeByLex(SafeEncoder.encode((String)key), serializer.serialize(min), serializer.serialize(max), offset, count)));
    }

    default public Long zlexcount(String key, Object min, Object max) {
        return (Long)this.run((jedis, serializer) -> jedis.zlexcount(SafeEncoder.encode((String)key), serializer.serialize(min), serializer.serialize(max)));
    }

    default public Long zremrangebylex(String key, Object min, Object max) {
        return (Long)this.run((jedis, serializer) -> jedis.zremrangeByLex(SafeEncoder.encode((String)key), serializer.serialize(min), serializer.serialize(max)));
    }
}

