/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis.command;

import io.enoa.nosql.redis.EnoaRedisConvert;
import io.enoa.nosql.redis.command._Runner;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.util.SafeEncoder;

interface SetCommand
extends _Runner {
    default public Long sadd(String key, Object ... member) {
        return (Long)this.run((jedis, serializer) -> jedis.sadd(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesValues(member)));
    }

    default public Long scard(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.scard(key));
    }

    default public <T> Set<T> sdiff(String ... keys) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.sdiff(EnoaRedisConvert.with(serializer).toBytesKeys(keys))));
    }

    default public Long sdiffstore(String dstkey, String ... keys) {
        return (Long)this.run((jedis, serializer) -> jedis.sdiffstore(dstkey, keys));
    }

    default public Boolean sismember(String key, Object member) {
        return (Boolean)this.run((jedis, serializer) -> jedis.sismember(SafeEncoder.encode((String)key), serializer.serialize(member)));
    }

    default public <T> Set<T> smembers(String key) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.smembers(SafeEncoder.encode((String)key))));
    }

    default public Long smove(String srckey, String dstkey, Object member) {
        return (Long)this.run((jedis, serializer) -> jedis.smove(SafeEncoder.encode((String)srckey), SafeEncoder.encode((String)dstkey), serializer.serialize(member)));
    }

    default public <T> T spop(String key) {
        return this.run((jedis, serializer) -> serializer.reduction(jedis.spop(SafeEncoder.encode((String)key))));
    }

    default public <T> Set<T> spop(String key, long count) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.spop(SafeEncoder.encode((String)key), count)));
    }

    default public <T> T srandmember(String key) {
        return this.run((jedis, serializer) -> serializer.reduction(jedis.srandmember(SafeEncoder.encode((String)key))));
    }

    default public <T> List<T> srandmember(String key, int count) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.srandmember(SafeEncoder.encode((String)key), count)));
    }

    default public Long srem(String key, Object ... member) {
        return (Long)this.run((jedis, serializer) -> jedis.srem(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesValues(member)));
    }

    default public <T> Set<T> sunion(String ... keys) {
        return (Set)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertSet(jedis.sunion(EnoaRedisConvert.with(serializer).toBytesKeys(keys))));
    }

    default public Long sunionstore(String dstkey, String ... keys) {
        return (Long)this.run((jedis, serializer) -> jedis.sunionstore(dstkey, keys));
    }

    default public <T> ScanResult<T> sscan(String key, String cursor) {
        return (ScanResult)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertScan((ScanResult<byte[]>)jedis.sscan(SafeEncoder.encode((String)key), SafeEncoder.encode((String)cursor))));
    }

    default public <T> ScanResult<T> sscan(String key, String cursor, ScanParams params) {
        return (ScanResult)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertScan((ScanResult<byte[]>)jedis.sscan(SafeEncoder.encode((String)key), SafeEncoder.encode((String)cursor), params)));
    }
}

