/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis.command;

import io.enoa.nosql.redis.command._Runner;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.JedisPubSub;
import redis.clients.util.SafeEncoder;

interface PubSubCommand
extends _Runner {
    default public List<String> pubsubchannels(String pattern) {
        return (List)this.run((jedis, serializer) -> jedis.pubsubChannels(pattern));
    }

    default public Long pubsubnumpat() {
        return (Long)this.run((jedis, serializer) -> jedis.pubsubNumPat());
    }

    default public Map<String, String> pubsubnumsub(String ... channels) {
        return (Map)this.run((jedis, serializer) -> jedis.pubsubNumSub(channels));
    }

    default public Long publish(String channel, Object message) {
        return (Long)this.run((jedis, serializer) -> jedis.publish(SafeEncoder.encode((String)channel), serializer.serialize(message)));
    }

    default public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.run((jedis, serializer) -> {
            jedis.psubscribe(jedisPubSub, patterns);
            return this;
        });
    }

    default public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.run((jedis, serializer) -> {
            jedis.subscribe(jedisPubSub, channels);
            return this;
        });
    }
}

