/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis.command;

import io.enoa.nosql.redis.EnoaRedisConvert;
import io.enoa.nosql.redis.command._Runner;
import java.util.List;
import redis.clients.jedis.BinaryClient;
import redis.clients.util.SafeEncoder;

interface ListCommand
extends _Runner {
    default public <T> List<T> blpop(int timeout, String ... keys) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.blpop(timeout, EnoaRedisConvert.with(serializer).toBytesKeys(keys))));
    }

    default public <T> List<T> blpop(int timeout, String key) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.blpop(timeout, (byte[][])new byte[][]{SafeEncoder.encode((String)key)})));
    }

    default public <T> List<T> blpop(String ... args) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.blpop(EnoaRedisConvert.with(serializer).toBytesKeys(args))));
    }

    default public <T> List<T> brpop(int timeout, String ... keys) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.brpop(timeout, EnoaRedisConvert.with(serializer).toBytesKeys(keys))));
    }

    default public <T> List<T> brpop(int timeout, String key) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.brpop(timeout, EnoaRedisConvert.with(serializer).toBytesKeys(key))));
    }

    default public <T> List<T> brpop(String ... args) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.brpop(EnoaRedisConvert.with(serializer).toBytesKeys(args))));
    }

    default public <T> T brpoplpush(String source, String destination, int timeout) {
        return this.run((jedis, serializer) -> serializer.reduction(jedis.brpoplpush(SafeEncoder.encode((String)source), SafeEncoder.encode((String)destination), timeout)));
    }

    default public String lindex(String key, long index) {
        return (String)this.run((jedis, serializer) -> jedis.lindex(key, index));
    }

    default public Long linsert(String key, BinaryClient.LIST_POSITION where, Object pivot, Object value) {
        return (Long)this.run((jedis, serializer) -> jedis.linsert(SafeEncoder.encode((String)key), where, serializer.serialize(pivot), serializer.serialize(value)));
    }

    default public Long llen(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.llen(key));
    }

    default public <T> T lpop(String key) {
        return this.run((jedis, serializer) -> serializer.reduction(jedis.lpop(SafeEncoder.encode((String)key))));
    }

    default public Long lpush(String key, Object ... values) {
        return (Long)this.run((jedis, serializer) -> jedis.lpush(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesValues(values)));
    }

    default public Long lpushx(String key, Object ... values) {
        return (Long)this.run((jedis, serializer) -> jedis.lpushx(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesValues(values)));
    }

    default public <T> List<T> lrange(String key, long start, long end) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.lrange(SafeEncoder.encode((String)key), start, end)));
    }

    default public Long lrem(String key, long count, Object value) {
        return (Long)this.run((jedis, serializer) -> jedis.lrem(SafeEncoder.encode((String)key), count, serializer.serialize(value)));
    }

    default public String lset(String key, long index, Object value) {
        return (String)this.run((jedis, serializer) -> jedis.lset(SafeEncoder.encode((String)key), index, serializer.serialize(value)));
    }

    default public String ltrim(String key, long start, long end) {
        return (String)this.run((jedis, serializer) -> jedis.ltrim(key, start, end));
    }

    default public <T> T rpop(String key) {
        return this.run((jedis, serializer) -> serializer.reduction(jedis.rpop(SafeEncoder.encode((String)key))));
    }

    default public <T> T rpoplpush(String srckey, String dstkey) {
        return this.run((jedis, serializer) -> serializer.reduction(jedis.rpoplpush(SafeEncoder.encode((String)srckey), SafeEncoder.encode((String)dstkey))));
    }

    default public Long rpush(String key, Object ... values) {
        return (Long)this.run((jedis, serializer) -> jedis.rpush(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesValues(values)));
    }

    default public Long rpushx(String key, Object ... values) {
        return (Long)this.run((jedis, serializer) -> jedis.rpushx(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesValues(values)));
    }
}

