/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis.command;

import io.enoa.nosql.redis.EnoaRedisConvert;
import io.enoa.nosql.redis.command._Runner;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.util.SafeEncoder;

interface KeyCommand
extends _Runner {
    default public Long del(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.del(key));
    }

    default public Long del(String ... keys) {
        return (Long)this.run((jedis, serializer) -> jedis.del(keys));
    }

    default public byte[] dump(String key) {
        return (byte[])this.run((jedis, serializer) -> jedis.dump(key));
    }

    default public Boolean exists(String key) {
        return (Boolean)this.run((jedis, serializer) -> jedis.exists(key));
    }

    default public Long exists(String ... keys) {
        return (Long)this.run((jedis, serializer) -> jedis.exists(keys));
    }

    default public Long expire(String key, int seconds) {
        return (Long)this.run((jedis, serializer) -> jedis.expire(key, seconds));
    }

    default public Long expireat(String key, long unixTime) {
        return (Long)this.run((jedis, serializer) -> jedis.expireAt(key, unixTime));
    }

    default public Set<String> keys(String pattern) {
        return (Set)this.run((jedis, serializer) -> jedis.keys(pattern));
    }

    default public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        return (String)this.run((jedis, serializer) -> jedis.migrate(host, port, key, destinationDb, timeout));
    }

    default public Long move(String key, int dbIndex) {
        return (Long)this.run((jedis, serializer) -> jedis.move(key, dbIndex));
    }

    default public String objectencoding(String string) {
        return (String)this.run((jedis, serializer) -> jedis.objectEncoding(string));
    }

    default public Long objectidletime(String string) {
        return (Long)this.run((jedis, serializer) -> jedis.objectIdletime(string));
    }

    default public Long objectrefcount(String string) {
        return (Long)this.run((jedis, serializer) -> jedis.objectRefcount(string));
    }

    default public Long persist(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.persist(key));
    }

    default public Long pexpire(String key, long milliseconds) {
        return (Long)this.run((jedis, serializer) -> jedis.pexpire(key, milliseconds));
    }

    default public Long pexpireat(String key, long millisecondsTimestamp) {
        return (Long)this.run((jedis, serializer) -> jedis.pexpireAt(key, millisecondsTimestamp));
    }

    default public Long pttl(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.pttl(key));
    }

    default public String randomkey() {
        return (String)this.run((jedis, serializer) -> jedis.randomKey());
    }

    default public String rename(String oldkey, String newkey) {
        return (String)this.run((jedis, serializer) -> jedis.rename(oldkey, newkey));
    }

    default public Long renamenx(String oldkey, String newkey) {
        return (Long)this.run((jedis, serializer) -> jedis.renamenx(oldkey, newkey));
    }

    default public String restore(String key, int ttl, byte[] serializedValue) {
        return (String)this.run((jedis, serializer) -> jedis.restore(key, ttl, serializedValue));
    }

    default public <T> List<T> sort(String key) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.sort(SafeEncoder.encode((String)key))));
    }

    default public <T> List<T> sort(String key, SortingParams sortingParameters) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.sort(SafeEncoder.encode((String)key), sortingParameters)));
    }

    default public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        return (Long)this.run((jedis, serializer) -> jedis.sort(key, sortingParameters, dstkey));
    }

    default public Long sort(String key, String dstkey) {
        return (Long)this.run((jedis, serializer) -> jedis.sort(key, dstkey));
    }

    default public Long ttl(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.ttl(key));
    }

    default public String type(String key) {
        return (String)this.run((jedis, serializer) -> jedis.type(key));
    }

    default public <T> ScanResult<T> scan(String cursor) {
        return (ScanResult)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertScan((ScanResult<byte[]>)jedis.scan(SafeEncoder.encode((String)cursor))));
    }

    default public <T> ScanResult<T> scan(String cursor, ScanParams params) {
        return (ScanResult)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertScan((ScanResult<byte[]>)jedis.scan(SafeEncoder.encode((String)cursor), params)));
    }
}

