/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis.command;

import io.enoa.nosql.redis.command._Runner;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.params.geo.GeoRadiusParam;

interface GeoCommand
extends _Runner {
    default public Long geoadd(String key, double longitude, double latitude, String member) {
        return (Long)this.run((jedis, serializer) -> jedis.geoadd(key, longitude, latitude, member));
    }

    default public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        return (Long)this.run((jedis, serializer) -> jedis.geoadd(key, memberCoordinateMap));
    }

    default public List<GeoCoordinate> geopos(String key, String ... members) {
        return (List)this.run((jedis, serializer) -> jedis.geopos(key, members));
    }

    default public Double geodist(String key, String member1, String member2) {
        return (Double)this.run((jedis, serializer) -> jedis.geodist(key, member1, member2));
    }

    default public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        return (Double)this.run((jedis, serializer) -> jedis.geodist(key, member1, member2, unit));
    }

    default public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return (List)this.run((jedis, serializer) -> jedis.georadius(key, longitude, latitude, radius, unit));
    }

    default public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return (List)this.run((jedis, serializer) -> jedis.georadius(key, longitude, latitude, radius, unit, param));
    }

    default public List<GeoRadiusResponse> georadiusbymember(String key, String member, double radius, GeoUnit unit) {
        return (List)this.run((jedis, serializer) -> jedis.georadiusByMember(key, member, radius, unit));
    }

    default public List<GeoRadiusResponse> georadiusbymember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return (List)this.run((jedis, serializer) -> jedis.georadiusByMember(key, member, radius, unit, param));
    }

    default public List<String> geohash(String key, String ... members) {
        return (List)this.run((jedis, serializer) -> jedis.geohash(key, members));
    }
}

