/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis;

import java.util.Collections;
import java.util.Set;
import redis.clients.jedis.JedisPoolConfig;

public class RedisSentinelConfig {
    private final String name;
    private final String masterName;
    private final Set<String> sentinels;
    private final JedisPoolConfig poolConfig;
    private final int connectionTimeout;
    private final int soTimeout;
    private final String passwd;
    private final int database;

    public RedisSentinelConfig(Builder builder) {
        this.name = builder.name;
        this.masterName = builder.masterName;
        this.sentinels = builder.sentinels;
        this.poolConfig = builder.poolConfig;
        this.connectionTimeout = builder.connectionTimeout;
        this.soTimeout = builder.soTimeout;
        this.passwd = builder.passwd;
        this.database = builder.database;
    }

    public String masterName() {
        return this.masterName;
    }

    public Set<String> sentinels() {
        return this.sentinels;
    }

    public JedisPoolConfig poolConfig() {
        return this.poolConfig;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public String passwd() {
        return this.passwd;
    }

    public int database() {
        return this.database;
    }

    public String name() {
        return this.name;
    }

    public static class Builder {
        private String masterName;
        private Set<String> sentinels = Collections.emptySet();
        private JedisPoolConfig poolConfig = new JedisPoolConfig();
        private int connectionTimeout = 2000;
        private int soTimeout = 2000;
        private String passwd;
        private int database = 0;
        private String name;

        public Builder() {
            this.poolConfig.setMaxIdle(8);
            this.poolConfig.setMaxTotal(10);
        }

        public RedisSentinelConfig build() {
            return new RedisSentinelConfig(this);
        }

        public Builder masterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        public Builder sentinels(Set<String> sentinels) {
            this.sentinels = sentinels;
            return this;
        }

        public Builder poolConfig(JedisPoolConfig poolConfig) {
            this.poolConfig = poolConfig;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder soTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        public Builder database(int database) {
            this.database = database;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }
    }
}

