/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.JedisPoolConfig;

public class RedisConfig {
    private final String name;
    private final String host;
    private final int port;
    private final String passwd;
    private final Integer connectionTimeout;
    private final Integer soTimeout;
    private final Integer database;
    private final boolean ssl;
    private final SSLSocketFactory sslSocketFactory;
    private final SSLParameters sslParameters;
    private final HostnameVerifier hostnameVerifier;
    private final JedisPoolConfig poolConfig;

    private RedisConfig(Builder builder) {
        this.name = builder.name;
        this.host = builder.host;
        this.port = builder.port;
        this.passwd = builder.passwd;
        this.connectionTimeout = builder.connectionTimeout;
        this.soTimeout = builder.soTimeout;
        this.database = builder.database;
        this.ssl = builder.ssl;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.sslParameters = builder.sslParameters;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.poolConfig = builder.poolConfig;
    }

    public String name() {
        return this.name;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String passwd() {
        return this.passwd;
    }

    public Integer connectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer soTimeout() {
        return this.soTimeout;
    }

    public Integer database() {
        return this.database;
    }

    public boolean ssl() {
        return this.ssl;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public SSLParameters sslParameters() {
        return this.sslParameters;
    }

    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public JedisPoolConfig poolConfig() {
        return this.poolConfig;
    }

    public static class Builder {
        private String name = "main";
        private String host;
        private int port = 6379;
        private String passwd;
        private Integer connectionTimeout = 2000;
        private Integer soTimeout = 2000;
        private Integer database;
        private boolean ssl = false;
        private SSLSocketFactory sslSocketFactory;
        private SSLParameters sslParameters;
        private HostnameVerifier hostnameVerifier;
        private JedisPoolConfig poolConfig = new JedisPoolConfig();

        public Builder() {
            this.poolConfig.setMaxIdle(8);
            this.poolConfig.setMaxTotal(10);
        }

        public RedisConfig build() {
            return new RedisConfig(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder soTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder database(int database) {
            this.database = database;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder sslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder poolConfig(JedisPoolConfig poolConfig) {
            this.poolConfig = poolConfig;
            return this;
        }
    }
}

