/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis;

import io.enoa.serialization.EoSerializer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import redis.clients.jedis.ScanResult;
import redis.clients.util.JedisByteHashMap;
import redis.clients.util.SafeEncoder;

public class EnoaRedisConvert {
    private static Map<EoSerializer, EnoaRedisConvert> CACHE = new HashMap<EoSerializer, EnoaRedisConvert>();
    private EoSerializer serializer;

    public static EnoaRedisConvert with(EoSerializer serializer) {
        EnoaRedisConvert convert = CACHE.get(serializer);
        if (convert != null) {
            return convert;
        }
        convert = new EnoaRedisConvert();
        convert.serializer = serializer;
        CACHE.put(serializer, convert);
        return convert;
    }

    public byte[][] toBytesKeys(String ... keys) {
        byte[][] result = new byte[keys.length][];
        int i = result.length;
        while (i-- > 0) {
            result[i] = SafeEncoder.encode((String)keys[i]);
        }
        return result;
    }

    public <T> byte[][] toBytesValues(T ... values) {
        byte[][] result = new byte[values.length][];
        int i = result.length;
        while (i-- > 0) {
            result[i] = this.serializer.serialize(values[i]);
        }
        return result;
    }

    public Map<byte[], Double> toBytesZmap(Map<String, Double> data) {
        try {
            HashMap<byte[], Double> ret = new HashMap<byte[], Double>();
            data.forEach((k, v) -> ret.put(SafeEncoder.encode((String)k), (Double)v));
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T> List<T> convertList(List<byte[]> data) {
        List rets = data.stream().map(b -> this.serializer.reduction(b)).collect(Collectors.toList());
        data.clear();
        return rets;
    }

    public <T> Set<T> convertSet(Set<byte[]> data) {
        Set rets = data.stream().map(s -> this.serializer.reduction(s)).collect(Collectors.toSet());
        data.clear();
        return rets;
    }

    public <T> ScanResult<T> convertScan(ScanResult<byte[]> data) {
        List rets0 = data.getResult();
        List<T> rets1 = EnoaRedisConvert.with(this.serializer).convertList(rets0);
        rets0.clear();
        return new ScanResult(data.getCursorAsBytes(), rets1);
    }

    public <T> Map.Entry<String, T> convertEntry(final Map.Entry<byte[], byte[]> data) {
        return new Map.Entry<String, T>(){

            @Override
            public String getKey() {
                return SafeEncoder.encode((byte[])((byte[])data.getKey()));
            }

            @Override
            public T getValue() {
                return EnoaRedisConvert.this.serializer.reduction((byte[])data.getValue());
            }

            @Override
            public T setValue(T value) {
                Object oldVal = this.getValue();
                data.setValue(EnoaRedisConvert.this.serializer.serialize(value));
                return oldVal;
            }
        };
    }

    public <T> Map<String, T> convertMap(Map<byte[], byte[]> data) {
        if (data == null) {
            return null;
        }
        try {
            HashMap ret = new HashMap();
            data.forEach((k, v) -> ret.put(SafeEncoder.encode((byte[])k), this.serializer.reduction(v)));
            data.clear();
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Map<byte[], byte[]> serializeMap(Map map) {
        try {
            JedisByteHashMap ret = new JedisByteHashMap();
            map.forEach((arg_0, arg_1) -> this.lambda$serializeMap$4((Map)ret, arg_0, arg_1));
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ void lambda$serializeMap$4(Map ret, Object k, Object v) {
        ret.put(SafeEncoder.encode((String)k.toString()), this.serializer.serialize(v));
    }
}

