/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.db.provider.db.trydb;

import io.enoa.db.EoDbConfig;
import io.enoa.db.EoDsConfig;
import io.enoa.db.EoDsFactory;
import io.enoa.firetpl.Firetpl;
import io.enoa.toolkit.namecase.INameCase;
import io.enoa.toolkit.namecase.NamecaseKit;
import io.enoa.toolkit.namecase.NamecaseType;
import io.enoa.trydb.ISqlReporter;
import io.enoa.trydb.dialect.IDialect;
import io.enoa.trydb.tx.TxLevel;

public class EoTrydbConfig
implements EoDbConfig {
    private final String name;
    private final boolean debug;
    private final EoDsFactory ds;
    private final EoDsConfig dsConfig;
    private final IDialect dialect;
    private final TxLevel level;
    private final ISqlReporter reporter;
    private final INameCase namecase;
    private final boolean showSql;
    private final Firetpl sqltemplate;

    private EoTrydbConfig(Builder builder) {
        this.name = builder.name;
        this.debug = builder.debug;
        this.ds = builder.ds;
        this.dsConfig = builder.dsConfig;
        this.dialect = builder.dialect;
        this.level = builder.level;
        this.reporter = builder.reporter;
        this.namecase = builder.namecase;
        this.showSql = builder.showSql;
        this.sqltemplate = builder.sqltemplate;
    }

    public String name() {
        return this.name;
    }

    public EoDsFactory ds() {
        return this.ds;
    }

    public EoDsConfig dsConfig() {
        return this.dsConfig;
    }

    public boolean debug() {
        return this.debug;
    }

    public IDialect dialect() {
        return this.dialect;
    }

    public TxLevel txlevel() {
        return this.level;
    }

    public ISqlReporter reporter() {
        return this.reporter;
    }

    public INameCase namecase() {
        return this.namecase;
    }

    public boolean showSql() {
        return this.showSql;
    }

    public Firetpl template() {
        return this.sqltemplate;
    }

    public static class Builder {
        private String name = "main";
        private boolean debug = false;
        private EoDsFactory ds;
        private EoDsConfig dsConfig;
        private IDialect dialect;
        private TxLevel level = TxLevel.REPEATABLE_READ;
        private ISqlReporter reporter;
        private INameCase namecase = NamecaseKit.namecase((NamecaseType)NamecaseType.CASE_UNDERLINE);
        private boolean showSql;
        private Firetpl sqltemplate;

        public EoTrydbConfig build() {
            return new EoTrydbConfig(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder debug() {
            return this.debug(true);
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder ds(EoDsFactory ds, EoDsConfig config) {
            this.ds = ds;
            this.dsConfig = config;
            return this;
        }

        public Builder dialect(IDialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public Builder txlevel(TxLevel level) {
            this.level = level;
            return this;
        }

        public Builder showSql() {
            return this.showSql(true);
        }

        public Builder showSql(boolean showSql) {
            this.showSql = showSql;
            return this;
        }

        public Builder reporter(ISqlReporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public Builder namecase(INameCase namecase) {
            this.namecase = namecase;
            return this;
        }

        public Builder template(Firetpl template) {
            this.sqltemplate = template;
            return this;
        }
    }
}

